/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.api.iam.models.AccountcommonPermissionV3;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AccessTokenPayload {
    @JsonProperty(value="bans")
    private List<Types.Ban> bans;
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="country")
    private String country;
    @JsonProperty(value="display_name")
    private String displayName;
    @JsonProperty(value="exp")
    private Integer exp;
    @JsonProperty(value="iat")
    private Integer iat;
    @JsonProperty(value="is_comply")
    private Boolean isComply;
    @JsonProperty(value="iss")
    private String iss;
    @JsonProperty(value="jflgs")
    private Integer jflgs;
    @JsonProperty(value="ipf")
    private String ipf;
    @JsonProperty(value="namespace")
    private String namespace;
    @JsonProperty(value="parent_namespace")
    private String parentNamespace;
    @JsonProperty(value="namespace_roles")
    private List<Types.Role> namespaceRoles;
    @JsonProperty(value="permissions")
    private List<Types.Permission> permissions;
    @JsonProperty(value="roles")
    private List<String> roles;
    @JsonProperty(value="scope")
    private String scope;
    @JsonProperty(value="sub")
    private String sub;
    @JsonProperty(value="union_id")
    private String unionId;
    @JsonProperty(value="union_namespace")
    private String unionNamespace;
    @JsonProperty(value="extend_namespace")
    private String extendNamespace;

    @JsonIgnore
    public AccessTokenPayload createFromJson(String json) throws JsonProcessingException {
        return (AccessTokenPayload)new ObjectMapper().readValue(json, this.getClass());
    }

    public List<Types.Ban> getBans() {
        return this.bans;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getCountry() {
        return this.country;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getExp() {
        return this.exp;
    }

    public Integer getIat() {
        return this.iat;
    }

    public Boolean getIsComply() {
        return this.isComply;
    }

    public String getIss() {
        return this.iss;
    }

    public Integer getJflgs() {
        return this.jflgs;
    }

    public String getIpf() {
        return this.ipf;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getParentNamespace() {
        return this.parentNamespace;
    }

    public List<Types.Role> getNamespaceRoles() {
        return this.namespaceRoles;
    }

    public List<Types.Permission> getPermissions() {
        return this.permissions;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public String getScope() {
        return this.scope;
    }

    public String getSub() {
        return this.sub;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public String getUnionNamespace() {
        return this.unionNamespace;
    }

    public String getExtendNamespace() {
        return this.extendNamespace;
    }

    @JsonProperty(value="bans")
    public void setBans(List<Types.Ban> bans) {
        this.bans = bans;
    }

    @JsonProperty(value="client_id")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @JsonProperty(value="country")
    public void setCountry(String country) {
        this.country = country;
    }

    @JsonProperty(value="display_name")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @JsonProperty(value="exp")
    public void setExp(Integer exp) {
        this.exp = exp;
    }

    @JsonProperty(value="iat")
    public void setIat(Integer iat) {
        this.iat = iat;
    }

    @JsonProperty(value="is_comply")
    public void setIsComply(Boolean isComply) {
        this.isComply = isComply;
    }

    @JsonProperty(value="iss")
    public void setIss(String iss) {
        this.iss = iss;
    }

    @JsonProperty(value="jflgs")
    public void setJflgs(Integer jflgs) {
        this.jflgs = jflgs;
    }

    @JsonProperty(value="ipf")
    public void setIpf(String ipf) {
        this.ipf = ipf;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="parent_namespace")
    public void setParentNamespace(String parentNamespace) {
        this.parentNamespace = parentNamespace;
    }

    @JsonProperty(value="namespace_roles")
    public void setNamespaceRoles(List<Types.Role> namespaceRoles) {
        this.namespaceRoles = namespaceRoles;
    }

    @JsonProperty(value="permissions")
    public void setPermissions(List<Types.Permission> permissions) {
        this.permissions = permissions;
    }

    @JsonProperty(value="roles")
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    @JsonProperty(value="scope")
    public void setScope(String scope) {
        this.scope = scope;
    }

    @JsonProperty(value="sub")
    public void setSub(String sub) {
        this.sub = sub;
    }

    @JsonProperty(value="union_id")
    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    @JsonProperty(value="union_namespace")
    public void setUnionNamespace(String unionNamespace) {
        this.unionNamespace = unionNamespace;
    }

    @JsonProperty(value="extend_namespace")
    public void setExtendNamespace(String extendNamespace) {
        this.extendNamespace = extendNamespace;
    }

    public static class Types {

        public static class Permission {
            @JsonProperty(value="Action")
            private Integer action;
            @JsonProperty(value="Resource")
            private String resource;

            public static Permission of(AccountcommonPermissionV3 permissionV3) {
                return Permission.builder().resource(permissionV3.getResource()).action(permissionV3.getAction()).build();
            }

            public static PermissionBuilder builder() {
                return new PermissionBuilder();
            }

            public Integer getAction() {
                return this.action;
            }

            public String getResource() {
                return this.resource;
            }

            @JsonProperty(value="Action")
            public void setAction(Integer action) {
                this.action = action;
            }

            @JsonProperty(value="Resource")
            public void setResource(String resource) {
                this.resource = resource;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Permission)) {
                    return false;
                }
                Permission other = (Permission)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$action = this.getAction();
                Integer other$action = other.getAction();
                if (this$action == null ? other$action != null : !((Object)this$action).equals(other$action)) {
                    return false;
                }
                String this$resource = this.getResource();
                String other$resource = other.getResource();
                return !(this$resource == null ? other$resource != null : !this$resource.equals(other$resource));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Permission;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $action = this.getAction();
                result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
                String $resource = this.getResource();
                result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
                return result;
            }

            public String toString() {
                return "AccessTokenPayload.Types.Permission(action=" + this.getAction() + ", resource=" + this.getResource() + ")";
            }

            public Permission(Integer action, String resource) {
                this.action = action;
                this.resource = resource;
            }

            public Permission() {
            }

            public static class PermissionBuilder {
                private Integer action;
                private String resource;

                PermissionBuilder() {
                }

                @JsonProperty(value="Action")
                public PermissionBuilder action(Integer action) {
                    this.action = action;
                    return this;
                }

                @JsonProperty(value="Resource")
                public PermissionBuilder resource(String resource) {
                    this.resource = resource;
                    return this;
                }

                public Permission build() {
                    return new Permission(this.action, this.resource);
                }

                public String toString() {
                    return "AccessTokenPayload.Types.Permission.PermissionBuilder(action=" + this.action + ", resource=" + this.resource + ")";
                }
            }
        }

        public static class Role {
            @JsonProperty(value="namespace")
            private String namespace;
            @JsonProperty(value="roleId")
            private String roleId;

            public String getNamespace() {
                return this.namespace;
            }

            public String getRoleId() {
                return this.roleId;
            }

            @JsonProperty(value="namespace")
            public void setNamespace(String namespace) {
                this.namespace = namespace;
            }

            @JsonProperty(value="roleId")
            public void setRoleId(String roleId) {
                this.roleId = roleId;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Role)) {
                    return false;
                }
                Role other = (Role)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$namespace = this.getNamespace();
                String other$namespace = other.getNamespace();
                if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                    return false;
                }
                String this$roleId = this.getRoleId();
                String other$roleId = other.getRoleId();
                return !(this$roleId == null ? other$roleId != null : !this$roleId.equals(other$roleId));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Role;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $namespace = this.getNamespace();
                result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
                String $roleId = this.getRoleId();
                result = result * 59 + ($roleId == null ? 43 : $roleId.hashCode());
                return result;
            }

            public String toString() {
                return "AccessTokenPayload.Types.Role(namespace=" + this.getNamespace() + ", roleId=" + this.getRoleId() + ")";
            }
        }

        public static class Ban {
            @JsonProperty(value="ban")
            private String ban;
            @JsonProperty(value="disabledDate")
            private String disabledDate;
            @JsonProperty(value="enabled")
            private Boolean enabled;
            @JsonProperty(value="endDate")
            private String endDate;
            @JsonProperty(value="targetedNamespace")
            private String targetedNamespace;

            public String getBan() {
                return this.ban;
            }

            public String getDisabledDate() {
                return this.disabledDate;
            }

            public Boolean getEnabled() {
                return this.enabled;
            }

            public String getEndDate() {
                return this.endDate;
            }

            public String getTargetedNamespace() {
                return this.targetedNamespace;
            }

            @JsonProperty(value="ban")
            public void setBan(String ban) {
                this.ban = ban;
            }

            @JsonProperty(value="disabledDate")
            public void setDisabledDate(String disabledDate) {
                this.disabledDate = disabledDate;
            }

            @JsonProperty(value="enabled")
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @JsonProperty(value="endDate")
            public void setEndDate(String endDate) {
                this.endDate = endDate;
            }

            @JsonProperty(value="targetedNamespace")
            public void setTargetedNamespace(String targetedNamespace) {
                this.targetedNamespace = targetedNamespace;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ban)) {
                    return false;
                }
                Ban other = (Ban)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                String this$ban = this.getBan();
                String other$ban = other.getBan();
                if (this$ban == null ? other$ban != null : !this$ban.equals(other$ban)) {
                    return false;
                }
                String this$disabledDate = this.getDisabledDate();
                String other$disabledDate = other.getDisabledDate();
                if (this$disabledDate == null ? other$disabledDate != null : !this$disabledDate.equals(other$disabledDate)) {
                    return false;
                }
                String this$endDate = this.getEndDate();
                String other$endDate = other.getEndDate();
                if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) {
                    return false;
                }
                String this$targetedNamespace = this.getTargetedNamespace();
                String other$targetedNamespace = other.getTargetedNamespace();
                return !(this$targetedNamespace == null ? other$targetedNamespace != null : !this$targetedNamespace.equals(other$targetedNamespace));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Ban;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                String $ban = this.getBan();
                result = result * 59 + ($ban == null ? 43 : $ban.hashCode());
                String $disabledDate = this.getDisabledDate();
                result = result * 59 + ($disabledDate == null ? 43 : $disabledDate.hashCode());
                String $endDate = this.getEndDate();
                result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
                String $targetedNamespace = this.getTargetedNamespace();
                result = result * 59 + ($targetedNamespace == null ? 43 : $targetedNamespace.hashCode());
                return result;
            }

            public String toString() {
                return "AccessTokenPayload.Types.Ban(ban=" + this.getBan() + ", disabledDate=" + this.getDisabledDate() + ", enabled=" + this.getEnabled() + ", endDate=" + this.getEndDate() + ", targetedNamespace=" + this.getTargetedNamespace() + ")";
            }
        }
    }
}

