/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.math.BigInteger;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.accelbyte.sdk.api.basic.models.NamespaceContext;
import net.accelbyte.sdk.api.basic.operations.namespace.GetNamespaceContext;
import net.accelbyte.sdk.api.basic.wrappers.Namespace;
import net.accelbyte.sdk.api.iam.models.BloomFilterJSON;
import net.accelbyte.sdk.api.iam.models.ModelRoleResponseV3;
import net.accelbyte.sdk.api.iam.models.OauthapiRevocationList;
import net.accelbyte.sdk.api.iam.models.OauthcommonJWKKey;
import net.accelbyte.sdk.api.iam.models.OauthcommonJWKSet;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenResponse;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenWithDeviceCookieResponseV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0.AuthorizeV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0.GetJWKSV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0.GetRevocationListV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0.PlatformTokenGrantV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0.TokenGrantV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0.VerifyTokenV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension.UserAuthenticationV3;
import net.accelbyte.sdk.api.iam.operations.roles.AdminGetRoleV3;
import net.accelbyte.sdk.api.iam.wrappers.OAuth20;
import net.accelbyte.sdk.api.iam.wrappers.OAuth20Extension;
import net.accelbyte.sdk.api.iam.wrappers.Roles;
import net.accelbyte.sdk.core.AccelByteConfig;
import net.accelbyte.sdk.core.AccessTokenPayload;
import net.accelbyte.sdk.core.AppInfo;
import net.accelbyte.sdk.core.HttpHeaders;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;
import net.accelbyte.sdk.core.SDKInfo;
import net.accelbyte.sdk.core.client.HttpClient;
import net.accelbyte.sdk.core.repository.ConfigRepository;
import net.accelbyte.sdk.core.repository.FlightIdRepository;
import net.accelbyte.sdk.core.repository.TokenRefresh;
import net.accelbyte.sdk.core.repository.TokenRepository;
import net.accelbyte.sdk.core.repository.TokenValidation;
import net.accelbyte.sdk.core.util.BloomFilter;
import net.accelbyte.sdk.core.util.Helper;
import net.accelbyte.sdk.core.validator.RoleCacheKey;
import net.accelbyte.sdk.core.validator.UserAuthContext;
import okhttp3.Credentials;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class AccelByteSDK
implements RequestRunner {
    private static final Logger log = Logger.getLogger(AccelByteSDK.class.getName());
    private static final String COOKIE_KEY_ACCESS_TOKEN = "access_token";
    private static final String DEFAULT_LOGIN_USER_SCOPE = "commerce account social publishing analytics";
    private static final String DEFAULT_CACHE_KEY = "default";
    private static final String CLAIM_SUB = "sub";
    private AccelByteConfig sdkConfiguration;
    private final Timer refreshTokenTimer = new Timer("RefreshTokenTimer", true);
    private final Object refreshTokenTaskLock = new Object();
    private TimerTask refreshTokenTask = null;
    private final ReentrantLock refreshTokenMethodLock = new ReentrantLock();
    private LoadingCache<String, Map<String, RSAPublicKey>> jwksCache;
    private LoadingCache<String, OauthapiRevocationList> revocationListCache;
    private LoadingCache<String, NamespaceContext> namespaceContextCache;
    private LoadingCache<RoleCacheKey, List<AccessTokenPayload.Types.Permission>> rolePermissionsCache;
    private static final BloomFilter bloomFilter = new BloomFilter();
    private float tokenRefreshRatio = 0.8f;
    private ObjectMapper objectMapper = new ObjectMapper();

    protected boolean internalValidateToken(SignedJWT signedJWT, String token, String resource, int action) {
        UserAuthContext authContext = UserAuthContext.builder().token(token).build();
        AccessTokenPayload.Types.Permission permission = AccessTokenPayload.Types.Permission.builder().resource(resource).action(action).build();
        return this.internalValidateToken(signedJWT, authContext, permission);
    }

    protected boolean internalValidateToken(SignedJWT signedJWT, UserAuthContext authContext, AccessTokenPayload.Types.Permission permission) {
        try {
            boolean isLocalTokenValidationEnabled;
            JWTClaimsSet jwtClaimsSet = signedJWT.getJWTClaimsSet();
            boolean bl = isLocalTokenValidationEnabled = this.jwksCache != null && this.revocationListCache != null;
            if (isLocalTokenValidationEnabled) {
                boolean isUserRevoked;
                String kid = signedJWT.getHeader().getKeyID();
                RSAPublicKey pubKey = (RSAPublicKey)((Map)this.jwksCache.get((Object)DEFAULT_CACHE_KEY)).get(kid);
                if (pubKey == null) {
                    return false;
                }
                RSASSAVerifier verifier = new RSASSAVerifier(pubKey);
                if (!signedJWT.verify((JWSVerifier)verifier)) {
                    return false;
                }
                if (jwtClaimsSet.getExpirationTime() == null || jwtClaimsSet.getExpirationTime().before(new Date())) {
                    return false;
                }
                OauthapiRevocationList revocationList = (OauthapiRevocationList)((Object)this.revocationListCache.get((Object)DEFAULT_CACHE_KEY));
                BloomFilterJSON revokedTokens = revocationList.getRevokedTokens();
                long[] bits = revokedTokens.getBits().stream().mapToLong(BigInteger::longValue).toArray();
                int k = revokedTokens.getK();
                int m = revokedTokens.getM();
                boolean isTokenRevoked = bloomFilter.mightContain(authContext.getToken(), k, BitSet.valueOf(bits), (long)m);
                if (isTokenRevoked) {
                    return false;
                }
                String tokenUserId = (String)jwtClaimsSet.getClaim(CLAIM_SUB);
                if (tokenUserId != null && !tokenUserId.equals("") && (isUserRevoked = revocationList.getRevokedUsers().stream().anyMatch(ruid -> tokenUserId.equals(ruid.getId())))) {
                    return false;
                }
            } else {
                OAuth20 oAuth20 = new OAuth20(this);
                oAuth20.verifyTokenV3(VerifyTokenV3.builder().token(authContext.getToken()).build());
            }
            if (Strings.isNullOrEmpty((String)permission.getResource())) {
                return true;
            }
            AccessTokenPayload accessTokenPayload = (AccessTokenPayload)this.objectMapper.convertValue((Object)jwtClaimsSet.toJSONObject(), AccessTokenPayload.class);
            return this.hasValidPermission(accessTokenPayload, authContext, permission);
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            return false;
        }
    }

    private boolean hasValidPermission(AccessTokenPayload tokenPayload, UserAuthContext authContext, AccessTokenPayload.Types.Permission permission) {
        if (permission == null) {
            return true;
        }
        if (Strings.isNullOrEmpty((String)tokenPayload.getNamespace())) {
            return false;
        }
        String tokenNamespace = tokenPayload.getNamespace();
        String expandedResource = this.expandResource(permission.getResource(), authContext.getNamespace(), authContext.getUserId());
        List<AccessTokenPayload.Types.Permission> originPermissions = tokenPayload.getPermissions();
        if (this.validatePermission(originPermissions, expandedResource, permission.getAction())) {
            return true;
        }
        String claimsUserId = tokenPayload.getSub();
        List<AccessTokenPayload.Types.Role> namespaceRoles = tokenPayload.getNamespaceRoles();
        if (!Strings.isNullOrEmpty((String)claimsUserId) && !namespaceRoles.isEmpty()) {
            List<AccessTokenPayload.Types.Permission> allRoleNamespacePermissions = namespaceRoles.stream().map(it -> {
                try {
                    RoleCacheKey key = RoleCacheKey.of(it, claimsUserId);
                    return (List)this.rolePermissionsCache.get((Object)key);
                }
                catch (ExecutionException e) {
                    log.warning(e.getMessage());
                    return null;
                }
            }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
            return !allRoleNamespacePermissions.isEmpty() && this.validatePermission(allRoleNamespacePermissions, expandedResource, permission.getAction());
        }
        List<String> claimRoles = tokenPayload.getRoles();
        if (claimRoles != null && !claimRoles.isEmpty()) {
            List<AccessTokenPayload.Types.Permission> allRolePermissions = claimRoles.stream().map(it -> {
                try {
                    RoleCacheKey key = RoleCacheKey.of(it, tokenNamespace, authContext.getUserId());
                    return (List)this.rolePermissionsCache.get((Object)key);
                }
                catch (ExecutionException e) {
                    log.warning(e.getMessage());
                    return null;
                }
            }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
            return !allRolePermissions.isEmpty() && this.validatePermission(allRolePermissions, expandedResource, permission.getAction());
        }
        return false;
    }

    private boolean validatePermission(List<AccessTokenPayload.Types.Permission> ownedPermissions, String requestedResource, int requestedAction) {
        if (ownedPermissions == null) {
            return false;
        }
        if (ownedPermissions.isEmpty()) {
            return false;
        }
        String[] requestedResourceElem = requestedResource.trim().split(":");
        for (AccessTokenPayload.Types.Permission ownedPermission : ownedPermissions) {
            int minResLen;
            boolean isResMatches;
            String[] ownedResourceElem = ownedPermission.getResource().split(":");
            if (ownedResourceElem.length == 0 || !(isResMatches = IntStream.range(0, minResLen = Math.min(ownedResourceElem.length, requestedResourceElem.length)).allMatch(i -> this.isResourceElementMatch(i, ownedResourceElem, requestedResourceElem))) || !this.isResourceMatch(ownedResourceElem, requestedResourceElem, ownedPermission.getAction(), requestedAction)) continue;
            return true;
        }
        return false;
    }

    private boolean isResourceMatch(String[] ownedResourceElem, String[] requestedResourceElem, int ownedAction, int requestedAction) {
        int ownedLen = ownedResourceElem.length;
        int requestedLen = requestedResourceElem.length;
        boolean matches = true;
        matches = ownedLen < requestedLen ? this.handleShorterRequestedResource(ownedResourceElem, ownedLen) : this.handleLongerRequestedResource(ownedResourceElem, ownedLen, requestedLen);
        if (!matches) {
            return false;
        }
        return (ownedAction & requestedAction) > 0;
    }

    private boolean handleLongerRequestedResource(String[] ownedResourceElem, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (ownedResourceElem[i].equals("*")) continue;
            return false;
        }
        return true;
    }

    private boolean handleShorterRequestedResource(String[] ownedResourceElem, int ownedLen) {
        if (ownedResourceElem[ownedLen - 1].equals("*")) {
            if (ownedLen < 2) {
                return true;
            }
            String segment = ownedResourceElem[ownedLen - 2];
            return !segment.equals("NAMESPACE") && !segment.equals("USER");
        }
        return false;
    }

    private boolean isResourceElementMatch(int index, String[] ownedResourceElem, String[] requestedResourceElem) {
        String ownElem = ownedResourceElem[index];
        String reqElem = requestedResourceElem[index];
        if (!ownElem.equals(reqElem) && !ownElem.equals("*")) {
            String prevOwnElem;
            if (index > 0 && ownElem.endsWith("-") && (prevOwnElem = ownedResourceElem[index - 1]).endsWith("NAMESPACE")) {
                if (reqElem.contains("-") && reqElem.split("-").length == 2 && reqElem.startsWith(ownElem)) {
                    return true;
                }
                if (reqElem.equals(ownElem + "-")) {
                    return true;
                }
                NamespaceContext namespaceContext = null;
                try {
                    if (this.namespaceContextCache != null) {
                        namespaceContext = (NamespaceContext)this.namespaceContextCache.get((Object)reqElem);
                    }
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                if (namespaceContext != null && namespaceContext.getType().equals("Game") && reqElem.startsWith(namespaceContext.getStudioNamespace())) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private String expandResource(String resource, String namespace, String userId) {
        String expandedResource = resource;
        if (!Strings.isNullOrEmpty((String)namespace)) {
            expandedResource = expandedResource.replace("{namespace}", namespace);
        }
        if (!Strings.isNullOrEmpty((String)userId)) {
            expandedResource = expandedResource.replace("{userId}", userId);
        }
        return expandedResource;
    }

    public AccelByteSDK(HttpClient<?> httpClient, TokenRepository tokenRepository, ConfigRepository configRepository) {
        this(httpClient, tokenRepository, configRepository, FlightIdRepository.getInstance());
    }

    AccelByteSDK(HttpClient<?> httpClient, TokenRepository tokenRepository, ConfigRepository configRepository, FlightIdRepository flightIdRepository) {
        this(new AccelByteConfig(httpClient, tokenRepository, configRepository, flightIdRepository));
    }

    public AccelByteSDK(AccelByteConfig sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        if (this.sdkConfiguration.getConfigRepository() instanceof TokenValidation) {
            TokenValidation tokenValidation = (TokenValidation)this.sdkConfiguration.getConfigRepository();
            this.namespaceContextCache = this.buildNamespaceContextCache(this, tokenValidation.getNamespaceContextRefreshInterval());
            if (tokenValidation.getLocalTokenValidationEnabled()) {
                this.jwksCache = this.buildJWKSLoadingCache(this, tokenValidation.getJwksRefreshInterval());
                this.revocationListCache = this.buildRevocationListLoadingCache(this, tokenValidation.getRevocationListRefreshInterval());
                try {
                    this.jwksCache.get((Object)DEFAULT_CACHE_KEY);
                    this.revocationListCache.get((Object)DEFAULT_CACHE_KEY);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            this.rolePermissionsCache = this.buildRolePermissionLoadingCache(this);
        }
    }

    public AccelByteConfig getSdkConfiguration() {
        return this.sdkConfiguration;
    }

    public HttpResponse runRequest(Operation operation) throws Exception {
        String selectedSecurity = Operation.Security.Basic.toString();
        if (!operation.getPreferredSecurityMethod().isEmpty()) {
            selectedSecurity = operation.getPreferredSecurityMethod();
        } else if (operation.getSecurities().size() > 0) {
            selectedSecurity = (String)operation.getSecurities().get(0);
        }
        HttpHeaders headers = new HttpHeaders();
        Map cookies = operation.getCookieParams();
        ConfigRepository configRepository = this.sdkConfiguration.getConfigRepository();
        String accessToken = this.sdkConfiguration.getTokenRepository().getToken();
        if (Operation.Security.Basic.toString().equals(selectedSecurity)) {
            String clientId = configRepository.getClientId();
            String clientSecret = configRepository.getClientSecret();
            headers.put((Object)"Authorization", (Object)Credentials.basic((String)clientId, (String)clientSecret));
        } else if (Operation.Security.Bearer.toString().equals(selectedSecurity)) {
            if (accessToken != null && !accessToken.isEmpty()) {
                headers.put((Object)"Authorization", (Object)(Operation.Security.Bearer.toString() + " " + accessToken));
            }
        } else if (Operation.Security.Cookie.toString().equals(selectedSecurity) && accessToken != null && !accessToken.isEmpty()) {
            cookies.put(COOKIE_KEY_ACCESS_TOKEN, accessToken);
        }
        if (configRepository.isAmazonTraceId()) {
            String version = configRepository.getAmazonTraceIdVersion();
            headers.put((Object)"X-Amzn-Trace-Id", (Object)Helper.generateAmazonTraceId((String)version));
        }
        FlightIdRepository flightIdRepository = this.sdkConfiguration.getFlightIdRepository();
        if (configRepository.isFlightIdEnabled()) {
            if (operation.hasXFlightId()) {
                headers.put((Object)"X-Flight-Id", (Object)operation.getXFlightId());
            } else {
                headers.put((Object)"X-Flight-Id", (Object)flightIdRepository.getFlightId());
            }
        }
        if (configRepository.isClientInfoHeader()) {
            String sdkName = SDKInfo.getInstance().getSdkName();
            String moduleInformation = SDKInfo.getInstance().getModuleInformation();
            AppInfo appInfo = configRepository.getAppInfo();
            String appName = appInfo.getAppName();
            String appVersion = appInfo.getAppVersion();
            String userAgent = String.format("%s %s (%s/%s)", sdkName, moduleInformation, appName, appVersion);
            headers.put((Object)"User-Agent", (Object)userAgent);
        }
        if (cookies.size() > 0) {
            ArrayList<String> cookieEntries = new ArrayList<String>();
            for (Map.Entry key : cookies.entrySet()) {
                cookieEntries.add(URLEncoder.encode((String)key.getKey(), StandardCharsets.UTF_8.toString()) + "=" + URLEncoder.encode((String)key.getValue(), StandardCharsets.UTF_8.toString()));
            }
            headers.put((Object)"Cookie", (Object)String.join((CharSequence)"; ", cookieEntries));
        }
        String baseUrl = this.sdkConfiguration.getConfigRepository().getBaseURL();
        return this.sdkConfiguration.getHttpClient().sendRequest(operation, baseUrl, headers);
    }

    public boolean loginUser(String username, String password) {
        return this.loginUser(username, password, DEFAULT_LOGIN_USER_SCOPE);
    }

    public boolean loginUser(String username, String password, String scope) {
        String codeVerifier = Helper.generateCodeVerifier();
        String codeChallenge = Helper.generateCodeChallenge((String)codeVerifier);
        String clientId = this.sdkConfiguration.getConfigRepository().getClientId();
        try {
            OAuth20 oAuth20 = new OAuth20(this);
            OAuth20Extension oAuth20Extension = new OAuth20Extension(this);
            AuthorizeV3 authorizeV3 = AuthorizeV3.builder().codeChallenge(codeChallenge).codeChallengeMethodFromEnum(AuthorizeV3.CodeChallengeMethod.S256).scope(scope).clientId(clientId).responseTypeFromEnum(AuthorizeV3.ResponseType.Code).build();
            String authorizeResponse = oAuth20.authorizeV3(authorizeV3);
            List authorizeParams = URLEncodedUtils.parse((URI)new URI(authorizeResponse), (Charset)StandardCharsets.UTF_8);
            String requestId = authorizeParams.stream().filter(q -> q.getName().equals(authorizeV3.getLocationQuery())).findFirst().map(NameValuePair::getValue).orElse(null);
            UserAuthenticationV3 userAuthenticationV3 = UserAuthenticationV3.builder().clientId(clientId).userName(username).password(password).requestId(requestId).build();
            String authenticationResponse = oAuth20Extension.userAuthenticationV3(userAuthenticationV3);
            List authenticationParams = URLEncodedUtils.parse((URI)new URI(authenticationResponse), (Charset)StandardCharsets.UTF_8);
            String code = authenticationParams.stream().filter(q -> q.getName().equals(userAuthenticationV3.getLocationQuery())).findFirst().map(NameValuePair::getValue).orElse(null);
            if (code == null) {
                return false;
            }
            Instant utcNow = Instant.now();
            TokenGrantV3 tokenGrantV3 = TokenGrantV3.builder().clientId(clientId).code(code).codeVerifier(codeVerifier).grantTypeFromEnum(TokenGrantV3.GrantType.AuthorizationCode).build();
            OauthmodelTokenWithDeviceCookieResponseV3 token = oAuth20.tokenGrantV3(tokenGrantV3);
            TokenRepository tokenRepository = this.sdkConfiguration.getTokenRepository();
            tokenRepository.storeToken(token.getAccessToken());
            if (tokenRepository instanceof TokenRefresh) {
                TokenRefresh tokenRefresh = (TokenRefresh)tokenRepository;
                long expiresIn = (long)((float)token.getExpiresIn().intValue() * this.tokenRefreshRatio);
                long refreshExpiresIn = (long)((float)token.getRefreshExpiresIn().intValue() * this.tokenRefreshRatio);
                tokenRefresh.setTokenExpiresAt(Date.from(utcNow.plusSeconds(expiresIn)));
                tokenRefresh.storeRefreshToken(token.getRefreshToken());
                tokenRefresh.setRefreshTokenExpiresAt(Date.from(utcNow.plusSeconds(refreshExpiresIn)));
                this.scheduleRefreshTokenTask(expiresIn);
            }
            return true;
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            return false;
        }
    }

    public boolean loginClient() {
        try {
            OAuth20 oAuth20 = new OAuth20(this);
            Instant utcNow = Instant.now();
            TokenGrantV3 tokenGrantV3 = TokenGrantV3.builder().grantTypeFromEnum(TokenGrantV3.GrantType.ClientCredentials).build();
            OauthmodelTokenWithDeviceCookieResponseV3 token = oAuth20.tokenGrantV3(tokenGrantV3);
            TokenRepository tokenRepository = this.sdkConfiguration.getTokenRepository();
            tokenRepository.storeToken(token.getAccessToken());
            if (tokenRepository instanceof TokenRefresh) {
                TokenRefresh tokenRefresh = (TokenRefresh)tokenRepository;
                long expiresIn = (long)((float)token.getExpiresIn().intValue() * this.tokenRefreshRatio);
                tokenRefresh.setTokenExpiresAt(Date.from(utcNow.plusSeconds(expiresIn)));
                tokenRefresh.storeRefreshToken(null);
                tokenRefresh.setRefreshTokenExpiresAt(null);
                this.scheduleRefreshTokenTask(expiresIn);
            }
            return true;
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            return false;
        }
    }

    public boolean loginOrRefreshClient() {
        TokenRepository tokenRepo = this.sdkConfiguration.getTokenRepository();
        if (!(tokenRepo instanceof TokenRefresh)) {
            throw new IllegalArgumentException("Token repository is not a Refresh Repository");
        }
        TokenRefresh refreshRepo = (TokenRefresh)tokenRepo;
        if (Strings.isNullOrEmpty((String)tokenRepo.getToken())) {
            return this.loginClient();
        }
        boolean isAccessTokenExpired = AccelByteSDK.isExpired(refreshRepo.getTokenExpiresAt());
        if (!isAccessTokenExpired) {
            return true;
        }
        return this.loginClient();
    }

    public boolean loginOrRefreshUser(String username, String password) {
        TokenRepository tokenRepo = this.sdkConfiguration.getTokenRepository();
        if (!(tokenRepo instanceof TokenRefresh)) {
            throw new IllegalArgumentException("Token repository is not a Refresh Repository");
        }
        TokenRefresh refreshRepo = (TokenRefresh)tokenRepo;
        if (Strings.isNullOrEmpty((String)tokenRepo.getToken())) {
            return this.loginUser(username, password);
        }
        boolean isAccessTokenExpired = AccelByteSDK.isExpired(refreshRepo.getTokenExpiresAt());
        boolean isRefreshTokenExpired = AccelByteSDK.isExpired(refreshRepo.getRefreshTokenExpiresAt());
        if (!isAccessTokenExpired) {
            return true;
        }
        if (!isRefreshTokenExpired) {
            return this.refreshToken();
        }
        return this.loginUser(username, password);
    }

    public boolean loginPlatform(String platformId, String platformToken) {
        try {
            OAuth20 oAuth20 = new OAuth20(this);
            Instant utcNow = Instant.now();
            PlatformTokenGrantV3 tokenGrantV3 = PlatformTokenGrantV3.builder().platformId(platformId).platformToken(platformToken).build();
            OauthmodelTokenResponse token = oAuth20.platformTokenGrantV3(tokenGrantV3);
            TokenRepository tokenRepository = this.sdkConfiguration.getTokenRepository();
            tokenRepository.storeToken(token.getAccessToken());
            if (tokenRepository instanceof TokenRefresh) {
                TokenRefresh tokenRefresh = (TokenRefresh)tokenRepository;
                long expiresIn = (long)((float)token.getExpiresIn().intValue() * this.tokenRefreshRatio);
                long refreshExpiresIn = (long)((float)token.getRefreshExpiresIn().intValue() * this.tokenRefreshRatio);
                tokenRefresh.setTokenExpiresAt(Date.from(utcNow.plusSeconds(expiresIn)));
                tokenRefresh.storeRefreshToken(token.getRefreshToken());
                tokenRefresh.setRefreshTokenExpiresAt(Date.from(utcNow.plusSeconds(refreshExpiresIn)));
                this.scheduleRefreshTokenTask(expiresIn);
            }
            return true;
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            return false;
        }
    }

    public boolean refreshToken() {
        return this.refreshToken(500L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshToken(long timeout, TimeUnit unit) {
        boolean acquiredLock = false;
        try {
            boolean isLoginClientOk;
            Date refreshTokenExpiresAt;
            acquiredLock = this.refreshTokenMethodLock.tryLock(timeout, unit);
            if (!acquiredLock) {
                log.warning(String.format("unable to acquire lock after (%s)%s", new Object[]{timeout, unit}));
                boolean bl = false;
                return bl;
            }
            TokenRepository tokenRepository = this.sdkConfiguration.getTokenRepository();
            String accessToken = tokenRepository.getToken();
            if (accessToken == null || accessToken.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            if (!(tokenRepository instanceof TokenRefresh)) {
                boolean bl = false;
                return bl;
            }
            TokenRefresh tokenRefresh = (TokenRefresh)tokenRepository;
            Date accessTokenExpiresAt = tokenRefresh.getTokenExpiresAt();
            String refreshToken = tokenRefresh.getRefreshToken();
            boolean isLoginUserOrLoginPlatform = refreshToken != null && !refreshToken.isEmpty();
            Date date = refreshTokenExpiresAt = isLoginUserOrLoginPlatform ? tokenRefresh.getRefreshTokenExpiresAt() : null;
            if (accessTokenExpiresAt == null) {
                boolean bl = false;
                return bl;
            }
            if (isLoginUserOrLoginPlatform) {
                boolean isRefreshTokenExpired = AccelByteSDK.isExpired(refreshTokenExpiresAt);
                if (isRefreshTokenExpired) {
                    boolean bl = false;
                    return bl;
                }
                Instant utcNow = Instant.now();
                OAuth20 oAuth20 = new OAuth20(this);
                TokenGrantV3 tokenGrantV3 = TokenGrantV3.builder().refreshToken(refreshToken).grantTypeFromEnum(TokenGrantV3.GrantType.RefreshToken).build();
                OauthmodelTokenWithDeviceCookieResponseV3 token = oAuth20.tokenGrantV3(tokenGrantV3);
                long expiresIn = (long)((float)token.getExpiresIn().intValue() * this.tokenRefreshRatio);
                long refreshExpiresIn = (long)((float)token.getRefreshExpiresIn().intValue() * this.tokenRefreshRatio);
                tokenRepository.storeToken(token.getAccessToken());
                tokenRefresh.setTokenExpiresAt(Date.from(utcNow.plusSeconds(expiresIn)));
                tokenRefresh.storeRefreshToken(token.getRefreshToken());
                tokenRefresh.setRefreshTokenExpiresAt(Date.from(utcNow.plusSeconds(refreshExpiresIn)));
                this.scheduleRefreshTokenTask(expiresIn);
                boolean bl = true;
                return bl;
            }
            boolean bl = isLoginClientOk = this.loginClient();
            return bl;
        }
        catch (Exception e) {
            log.warning(e.getMessage());
        }
        finally {
            if (acquiredLock) {
                this.refreshTokenMethodLock.unlock();
            }
        }
        return false;
    }

    public boolean validateToken(String token) {
        return this.validateToken(token, null, 0);
    }

    public boolean validateToken(String token, String resource, int action) {
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            return this.internalValidateToken(signedJWT, token, resource, action);
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            return false;
        }
    }

    public boolean validateToken(UserAuthContext authContext, AccessTokenPayload.Types.Permission permission) {
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)authContext.getToken());
            return this.internalValidateToken(signedJWT, authContext, permission);
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            return false;
        }
    }

    public AccessTokenPayload parseAccessToken(String token, Boolean validateFirst) {
        try {
            boolean isValid;
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            if (validateFirst.booleanValue() && !(isValid = this.internalValidateToken(signedJWT, token, null, 0))) {
                return null;
            }
            String payloadStr = signedJWT.getPayload().toString();
            return new AccessTokenPayload().createFromJson(payloadStr);
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            return null;
        }
    }

    public boolean logout() {
        try {
            TokenRepository tokenRepository = this.sdkConfiguration.getTokenRepository();
            tokenRepository.removeToken();
            if (tokenRepository instanceof TokenRefresh) {
                TokenRefresh tokenRefresh = (TokenRefresh)tokenRepository;
                tokenRefresh.setTokenExpiresAt(null);
                tokenRefresh.removeRefreshToken();
                tokenRefresh.setRefreshTokenExpiresAt(null);
                this.cancelRefreshTokenTask();
            }
            return true;
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRefreshTokenTask(long delaySeconds) {
        Object object = this.refreshTokenTaskLock;
        synchronized (object) {
            if (this.refreshTokenTask != null) {
                this.refreshTokenTask.cancel();
            }
            this.refreshTokenTask = new TimerTask(){

                @Override
                public void run() {
                    boolean isRefreshTokenOk = AccelByteSDK.this.refreshToken();
                    if (!isRefreshTokenOk) {
                        AccelByteSDK.this.scheduleRefreshTokenTask(10L);
                    }
                }
            };
            this.refreshTokenTimer.schedule(this.refreshTokenTask, delaySeconds * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRefreshTokenTask() {
        Object object = this.refreshTokenTaskLock;
        synchronized (object) {
            if (this.refreshTokenTask != null) {
                this.refreshTokenTask.cancel();
            }
        }
    }

    private static boolean isExpired(Date expiresAt) {
        long utcNowEpoch;
        long tokenExpiresAtEpoch = expiresAt.getTime();
        boolean isExpired = tokenExpiresAtEpoch - (utcNowEpoch = Date.from(Instant.now()).getTime()) <= 0L;
        return isExpired;
    }

    private LoadingCache<RoleCacheKey, List<AccessTokenPayload.Types.Permission>> buildRolePermissionLoadingCache(final AccelByteSDK sdk) {
        CacheLoader<RoleCacheKey, List<AccessTokenPayload.Types.Permission>> rolePermissionLoader = new CacheLoader<RoleCacheKey, List<AccessTokenPayload.Types.Permission>>(){

            public List<AccessTokenPayload.Types.Permission> load(RoleCacheKey key) throws Exception {
                Roles rolesWrapper = new Roles(sdk);
                AdminGetRoleV3 param = AdminGetRoleV3.builder().roleId(key.getRoleId()).build();
                ModelRoleResponseV3 getRoleV3Result = rolesWrapper.adminGetRoleV3(param);
                List<AccessTokenPayload.Types.Permission> permissions = getRoleV3Result.getPermissions().stream().map(AccessTokenPayload.Types.Permission::of).collect(Collectors.toList());
                permissions = permissions.stream().peek(it -> {
                    String expandedPermission = AccelByteSDK.this.expandResource(it.getResource(), key.getNamespace(), key.getUserId());
                    it.setResource(expandedPermission);
                }).collect(Collectors.toList());
                return permissions;
            }
        };
        int rolePermissionRefreshIntervalSeconds = 300;
        return CacheBuilder.newBuilder().refreshAfterWrite((long)rolePermissionRefreshIntervalSeconds, TimeUnit.SECONDS).build((CacheLoader)rolePermissionLoader);
    }

    private LoadingCache<String, Map<String, RSAPublicKey>> buildJWKSLoadingCache(final AccelByteSDK sdk, int refreshIntervalSeconds) {
        CacheLoader<String, Map<String, RSAPublicKey>> jwksLoader = new CacheLoader<String, Map<String, RSAPublicKey>>(){

            public Map<String, RSAPublicKey> load(String key) throws Exception {
                OAuth20 oauthWrapper = new OAuth20(sdk);
                OauthcommonJWKSet getJwksV3Result = oauthWrapper.getJWKSV3(GetJWKSV3.builder().build());
                Base64.Decoder urlDecoder = Base64.getUrlDecoder();
                KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
                Map<String, RSAPublicKey> result = getJwksV3Result.getKeys().stream().collect(Collectors.toMap(OauthcommonJWKKey::getKid, jwkKey -> {
                    try {
                        BigInteger modulus = new BigInteger(1, urlDecoder.decode(jwkKey.getN()));
                        BigInteger exponent = new BigInteger(1, urlDecoder.decode(jwkKey.getE()));
                        RSAPublicKeySpec rsaPubKeySpec = new RSAPublicKeySpec(modulus, exponent);
                        RSAPublicKey pubKey = (RSAPublicKey)rsaKeyFactory.generatePublic(rsaPubKeySpec);
                        return pubKey;
                    }
                    catch (InvalidKeySpecException e) {
                        log.warning(e.getMessage());
                        return null;
                    }
                }));
                return result;
            }
        };
        return CacheBuilder.newBuilder().refreshAfterWrite((long)refreshIntervalSeconds, TimeUnit.SECONDS).build((CacheLoader)jwksLoader);
    }

    private LoadingCache<String, OauthapiRevocationList> buildRevocationListLoadingCache(final AccelByteSDK sdk, int refreshIntervalSeconds) {
        CacheLoader<String, OauthapiRevocationList> revocationLoader = new CacheLoader<String, OauthapiRevocationList>(){

            public OauthapiRevocationList load(String key) throws Exception {
                OAuth20 oauthWrapper = new OAuth20(sdk);
                OauthapiRevocationList getRevocationListV3Result = oauthWrapper.getRevocationListV3(GetRevocationListV3.builder().build());
                return getRevocationListV3Result;
            }
        };
        return CacheBuilder.newBuilder().refreshAfterWrite((long)refreshIntervalSeconds, TimeUnit.SECONDS).build((CacheLoader)revocationLoader);
    }

    private LoadingCache<String, NamespaceContext> buildNamespaceContextCache(final AccelByteSDK sdk, int refreshIntervalSeconds) {
        CacheLoader<String, NamespaceContext> revocationLoader = new CacheLoader<String, NamespaceContext>(){

            public NamespaceContext load(String key) throws Exception {
                Namespace namespaceWrapper = new Namespace((RequestRunner)sdk);
                NamespaceContext namespaceContext = namespaceWrapper.getNamespaceContext(GetNamespaceContext.builder().namespace(key).build());
                return namespaceContext;
            }
        };
        return CacheBuilder.newBuilder().refreshAfterWrite((long)refreshIntervalSeconds, TimeUnit.SECONDS).build((CacheLoader)revocationLoader);
    }
}

