/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.wrappers;

import net.accelbyte.sdk.api.iam.models.OauthmodelTokenResponseV3;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenWithDeviceCookieResponseV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_v4.AuthenticationWithPlatformLinkV4;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_v4.GenerateTokenByNewHeadlessAccountV4;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_v4.PlatformTokenGrantV4;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_v4.RequestTargetTokenResponseV4;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_v4.SimultaneousLoginV4;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_v4.TokenGrantV4;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_v4.Verify2faCodeV4;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class OAuth20V4 {
    private RequestRunner sdk;
    private String customBasePath = "";

    public OAuth20V4(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("iam");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public OAuth20V4(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public OauthmodelTokenResponseV3 authenticationWithPlatformLinkV4(AuthenticationWithPlatformLinkV4 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelTokenResponseV3 generateTokenByNewHeadlessAccountV4(GenerateTokenByNewHeadlessAccountV4 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelTokenResponseV3 verify2faCodeV4(Verify2faCodeV4 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelTokenResponseV3 platformTokenGrantV4(PlatformTokenGrantV4 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelTokenResponseV3 simultaneousLoginV4(SimultaneousLoginV4 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelTokenWithDeviceCookieResponseV3 tokenGrantV4(TokenGrantV4 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelTokenResponseV3 requestTargetTokenResponseV4(RequestTargetTokenResponseV4 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

