/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.wrappers;

import net.accelbyte.sdk.api.iam.models.OauthmodelCountryLocationResponse;
import net.accelbyte.sdk.api.iam.models.OauthmodelOneTimeLinkingCodeResponse;
import net.accelbyte.sdk.api.iam.models.OauthmodelOneTimeLinkingCodeValidationResponse;
import net.accelbyte.sdk.api.iam.models.OauthmodelPlatformTokenRefreshResponseV3;
import net.accelbyte.sdk.api.iam.models.OauthmodelTargetTokenCodeResponse;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenResponseV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension.AuthenticationWithPlatformLinkV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension.GenerateTokenByNewHeadlessAccountV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension.GetCountryLocationV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension.Logout;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension.PlatformAuthenticationV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension.PlatformTokenRefreshV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension.RequestOneTimeLinkingCodeV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension.RequestTargetTokenResponseV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension.RequestTokenByOneTimeLinkCodeResponseV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension.RequestTokenExchangeCodeV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension.UserAuthenticationV3;
import net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension.ValidateOneTimeLinkingCodeV3;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class OAuth20Extension {
    private RequestRunner sdk;
    private String customBasePath = "";

    public OAuth20Extension(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("iam");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public OAuth20Extension(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public String userAuthenticationV3(UserAuthenticationV3 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelTokenResponseV3 authenticationWithPlatformLinkV3(AuthenticationWithPlatformLinkV3 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelTokenResponseV3 generateTokenByNewHeadlessAccountV3(GenerateTokenByNewHeadlessAccountV3 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelOneTimeLinkingCodeResponse requestOneTimeLinkingCodeV3(RequestOneTimeLinkingCodeV3 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelOneTimeLinkingCodeValidationResponse validateOneTimeLinkingCodeV3(ValidateOneTimeLinkingCodeV3 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelTokenResponseV3 requestTokenByOneTimeLinkCodeResponseV3(RequestTokenByOneTimeLinkCodeResponseV3 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelCountryLocationResponse getCountryLocationV3(GetCountryLocationV3 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public void logout(Logout input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelTargetTokenCodeResponse requestTokenExchangeCodeV3(RequestTokenExchangeCodeV3 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public String platformAuthenticationV3(PlatformAuthenticationV3 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelPlatformTokenRefreshResponseV3 platformTokenRefreshV3(PlatformTokenRefreshV3 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public OauthmodelTokenResponseV3 requestTargetTokenResponseV3(RequestTargetTokenResponseV3 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

