/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.wrappers;

import net.accelbyte.sdk.api.iam.models.ModelInputValidationConfigVersion;
import net.accelbyte.sdk.api.iam.models.ModelInputValidationsPublicResponse;
import net.accelbyte.sdk.api.iam.models.ModelInputValidationsResponse;
import net.accelbyte.sdk.api.iam.operations.input_validations.AdminGetInputValidations;
import net.accelbyte.sdk.api.iam.operations.input_validations.AdminResetInputValidations;
import net.accelbyte.sdk.api.iam.operations.input_validations.AdminUpdateInputValidations;
import net.accelbyte.sdk.api.iam.operations.input_validations.PublicGetInputValidationByField;
import net.accelbyte.sdk.api.iam.operations.input_validations.PublicGetInputValidations;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class InputValidations {
    private RequestRunner sdk;
    private String customBasePath = "";

    public InputValidations(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("iam");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public InputValidations(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public ModelInputValidationsResponse adminGetInputValidations(AdminGetInputValidations input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public void adminUpdateInputValidations(AdminUpdateInputValidations input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public void adminResetInputValidations(AdminResetInputValidations input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ModelInputValidationsPublicResponse publicGetInputValidations(PublicGetInputValidations input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ModelInputValidationConfigVersion publicGetInputValidationByField(PublicGetInputValidationByField input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

