/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.wrappers;

import net.accelbyte.sdk.api.iam.models.ModelConfigValueResponseV3;
import net.accelbyte.sdk.api.iam.operations.config.AdminGetConfigValueV3;
import net.accelbyte.sdk.api.iam.operations.config.PublicGetConfigValueV3;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class Config {
    private RequestRunner sdk;
    private String customBasePath = "";

    public Config(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("iam");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public Config(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public ModelConfigValueResponseV3 adminGetConfigValueV3(AdminGetConfigValueV3 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ModelConfigValueResponseV3 publicGetConfigValueV3(PublicGetConfigValueV3 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

