/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users_v4;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.AccountcommonUserPlatforms;
import net.accelbyte.sdk.api.iam.models.ModelPlatformUserIDRequestV4;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicListUserIDByPlatformUserIDsV4
extends Operation {
    private String path = "/iam/v4/public/namespaces/{namespace}/platforms/{platformId}/users";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String platformId;
    private Boolean rawPUID;
    private ModelPlatformUserIDRequestV4 body;

    @Deprecated
    public PublicListUserIDByPlatformUserIDsV4(String customBasePath, String namespace, String platformId, Boolean rawPUID, ModelPlatformUserIDRequestV4 body) {
        this.namespace = namespace;
        this.platformId = platformId;
        this.rawPUID = rawPUID;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.platformId != null) {
            pathParams.put("platformId", this.platformId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("rawPUID", this.rawPUID == null ? null : Arrays.asList(String.valueOf(this.rawPUID)));
        return queryParams;
    }

    public ModelPlatformUserIDRequestV4 getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.platformId != null;
    }

    public AccountcommonUserPlatforms parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new AccountcommonUserPlatforms().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("rawPUID", "None");
        return result;
    }

    public static PublicListUserIDByPlatformUserIDsV4Builder builder() {
        return new PublicListUserIDByPlatformUserIDsV4Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public Boolean getRawPUID() {
        return this.rawPUID;
    }

    public ModelPlatformUserIDRequestV4 getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setRawPUID(Boolean rawPUID) {
        this.rawPUID = rawPUID;
    }

    public void setBody(ModelPlatformUserIDRequestV4 body) {
        this.body = body;
    }

    public static class PublicListUserIDByPlatformUserIDsV4Builder {
        private String customBasePath;
        private String namespace;
        private String platformId;
        private Boolean rawPUID;
        private ModelPlatformUserIDRequestV4 body;

        PublicListUserIDByPlatformUserIDsV4Builder() {
        }

        public PublicListUserIDByPlatformUserIDsV4Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PublicListUserIDByPlatformUserIDsV4Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicListUserIDByPlatformUserIDsV4Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public PublicListUserIDByPlatformUserIDsV4Builder rawPUID(Boolean rawPUID) {
            this.rawPUID = rawPUID;
            return this;
        }

        public PublicListUserIDByPlatformUserIDsV4Builder body(ModelPlatformUserIDRequestV4 body) {
            this.body = body;
            return this;
        }

        public PublicListUserIDByPlatformUserIDsV4 build() {
            return new PublicListUserIDByPlatformUserIDsV4(this.customBasePath, this.namespace, this.platformId, this.rawPUID, this.body);
        }

        public String toString() {
            return "PublicListUserIDByPlatformUserIDsV4.PublicListUserIDByPlatformUserIDsV4Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", platformId=" + this.platformId + ", rawPUID=" + this.rawPUID + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

