/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users_v4;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelUserResponseV3;
import net.accelbyte.sdk.api.iam.models.ModelUserUpdateRequestV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminUpdateUserV4
extends Operation {
    private String path = "/iam/v4/admin/namespaces/{namespace}/users/{userId}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private ModelUserUpdateRequestV3 body;

    @Deprecated
    public AdminUpdateUserV4(String customBasePath, String namespace, String userId, ModelUserUpdateRequestV3 body) {
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public ModelUserUpdateRequestV3 getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public ModelUserResponseV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelUserResponseV3().createFromJson(json);
    }

    public static AdminUpdateUserV4Builder builder() {
        return new AdminUpdateUserV4Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public ModelUserUpdateRequestV3 getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(ModelUserUpdateRequestV3 body) {
        this.body = body;
    }

    public static class AdminUpdateUserV4Builder {
        private String customBasePath;
        private String namespace;
        private String userId;
        private ModelUserUpdateRequestV3 body;

        AdminUpdateUserV4Builder() {
        }

        public AdminUpdateUserV4Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminUpdateUserV4Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminUpdateUserV4Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AdminUpdateUserV4Builder body(ModelUserUpdateRequestV3 body) {
            this.body = body;
            return this;
        }

        public AdminUpdateUserV4 build() {
            return new AdminUpdateUserV4(this.customBasePath, this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "AdminUpdateUserV4.AdminUpdateUserV4Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

