/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicWebLinkPlatformEstablish
extends Operation {
    private String path = "/iam/v3/public/namespaces/{namespace}/users/me/platforms/{platformId}/web/link/establish";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = "PLACEHOLDER";
    private String namespace;
    private String platformId;
    private String code;
    private String state;

    @Deprecated
    public PublicWebLinkPlatformEstablish(String customBasePath, String namespace, String platformId, String code, String state) {
        this.namespace = namespace;
        this.platformId = platformId;
        this.code = code;
        this.state = state;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.platformId != null) {
            pathParams.put("platformId", this.platformId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("code", this.code == null ? null : Arrays.asList(this.code));
        queryParams.put("state", this.state == null ? null : Arrays.asList(this.state));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.platformId == null) {
            return false;
        }
        return this.state != null;
    }

    public String parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        String json = Helper.convertInputStreamToString((InputStream)payload);
        if (code != 302) {
            throw new HttpResponseException(code, json);
        }
        return json;
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("code", "None");
        result.put("state", "None");
        return result;
    }

    public static PublicWebLinkPlatformEstablishBuilder builder() {
        return new PublicWebLinkPlatformEstablishBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public String getCode() {
        return this.code;
    }

    public String getState() {
        return this.state;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setState(String state) {
        this.state = state;
    }

    public static class PublicWebLinkPlatformEstablishBuilder {
        private String customBasePath;
        private String namespace;
        private String platformId;
        private String code;
        private String state;

        PublicWebLinkPlatformEstablishBuilder() {
        }

        public PublicWebLinkPlatformEstablishBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PublicWebLinkPlatformEstablishBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicWebLinkPlatformEstablishBuilder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public PublicWebLinkPlatformEstablishBuilder code(String code) {
            this.code = code;
            return this;
        }

        public PublicWebLinkPlatformEstablishBuilder state(String state) {
            this.state = state;
            return this;
        }

        public PublicWebLinkPlatformEstablish build() {
            return new PublicWebLinkPlatformEstablish(this.customBasePath, this.namespace, this.platformId, this.code, this.state);
        }

        public String toString() {
            return "PublicWebLinkPlatformEstablish.PublicWebLinkPlatformEstablishBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", platformId=" + this.platformId + ", code=" + this.code + ", state=" + this.state + ")";
        }
    }
}

