/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelWebLinkingResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicWebLinkPlatform
extends Operation {
    private String path = "/iam/v3/public/namespaces/{namespace}/users/me/platforms/{platformId}/web/link";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String platformId;
    private String clientId;
    private String redirectUri;

    @Deprecated
    public PublicWebLinkPlatform(String customBasePath, String namespace, String platformId, String clientId, String redirectUri) {
        this.namespace = namespace;
        this.platformId = platformId;
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.platformId != null) {
            pathParams.put("platformId", this.platformId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("clientId", this.clientId == null ? null : Arrays.asList(this.clientId));
        queryParams.put("redirectUri", this.redirectUri == null ? null : Arrays.asList(this.redirectUri));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.platformId != null;
    }

    public ModelWebLinkingResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelWebLinkingResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("clientId", "None");
        result.put("redirectUri", "None");
        return result;
    }

    public static PublicWebLinkPlatformBuilder builder() {
        return new PublicWebLinkPlatformBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public static class PublicWebLinkPlatformBuilder {
        private String customBasePath;
        private String namespace;
        private String platformId;
        private String clientId;
        private String redirectUri;

        PublicWebLinkPlatformBuilder() {
        }

        public PublicWebLinkPlatformBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PublicWebLinkPlatformBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicWebLinkPlatformBuilder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public PublicWebLinkPlatformBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public PublicWebLinkPlatformBuilder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public PublicWebLinkPlatform build() {
            return new PublicWebLinkPlatform(this.customBasePath, this.namespace, this.platformId, this.clientId, this.redirectUri);
        }

        public String toString() {
            return "PublicWebLinkPlatform.PublicWebLinkPlatformBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", platformId=" + this.platformId + ", clientId=" + this.clientId + ", redirectUri=" + this.redirectUri + ")";
        }
    }
}

