/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelPublicUserInformationResponseV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicSearchUserV3
extends Operation {
    private String path = "/iam/v3/public/namespaces/{namespace}/users";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String by;
    private Integer limit;
    private Integer offset;
    private String platformBy;
    private String platformId;
    private String query;

    @Deprecated
    public PublicSearchUserV3(String customBasePath, String namespace, String by, Integer limit, Integer offset, String platformBy, String platformId, String query) {
        this.namespace = namespace;
        this.by = by;
        this.limit = limit;
        this.offset = offset;
        this.platformBy = platformBy;
        this.platformId = platformId;
        this.query = query;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("by", this.by == null ? null : Arrays.asList(this.by));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("platformBy", this.platformBy == null ? null : Arrays.asList(this.platformBy));
        queryParams.put("platformId", this.platformId == null ? null : Arrays.asList(this.platformId));
        queryParams.put("query", this.query == null ? null : Arrays.asList(this.query));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ModelPublicUserInformationResponseV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelPublicUserInformationResponseV3().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("by", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("platformBy", "None");
        result.put("platformId", "None");
        result.put("query", "None");
        return result;
    }

    public static PublicSearchUserV3Builder builder() {
        return new PublicSearchUserV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getBy() {
        return this.by;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getPlatformBy() {
        return this.platformBy;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public String getQuery() {
        return this.query;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBy(String by) {
        this.by = by;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setPlatformBy(String platformBy) {
        this.platformBy = platformBy;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public static class PublicSearchUserV3Builder {
        private String customBasePath;
        private String namespace;
        private String by;
        private Integer limit;
        private Integer offset;
        private String platformBy;
        private String platformId;
        private String query;

        PublicSearchUserV3Builder() {
        }

        public PublicSearchUserV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PublicSearchUserV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicSearchUserV3Builder by(String by) {
            this.by = by;
            return this;
        }

        public PublicSearchUserV3Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PublicSearchUserV3Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public PublicSearchUserV3Builder platformBy(String platformBy) {
            this.platformBy = platformBy;
            return this;
        }

        public PublicSearchUserV3Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public PublicSearchUserV3Builder query(String query) {
            this.query = query;
            return this;
        }

        public PublicSearchUserV3 build() {
            return new PublicSearchUserV3(this.customBasePath, this.namespace, this.by, this.limit, this.offset, this.platformBy, this.platformId, this.query);
        }

        public String toString() {
            return "PublicSearchUserV3.PublicSearchUserV3Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", by=" + this.by + ", limit=" + this.limit + ", offset=" + this.offset + ", platformBy=" + this.platformBy + ", platformId=" + this.platformId + ", query=" + this.query + ")";
        }
    }
}

