/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelLinkRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicProcessWebLinkPlatformV3
extends Operation {
    private String path = "/iam/v3/public/namespaces/{namespace}/users/me/platforms/{platformId}/web/link/process";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String platformId;
    private String code;
    private String state;

    @Deprecated
    public PublicProcessWebLinkPlatformV3(String customBasePath, String namespace, String platformId, String code, String state) {
        this.namespace = namespace;
        this.platformId = platformId;
        this.code = code;
        this.state = state;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.platformId != null) {
            pathParams.put("platformId", this.platformId);
        }
        return pathParams;
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.code != null) {
            formDataParams.put("code", this.code);
        }
        if (this.state != null) {
            formDataParams.put("state", this.state);
        }
        return formDataParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.platformId == null) {
            return false;
        }
        return this.state != null;
    }

    public ModelLinkRequest parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelLinkRequest().createFromJson(json);
    }

    public static PublicProcessWebLinkPlatformV3Builder builder() {
        return new PublicProcessWebLinkPlatformV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public String getCode() {
        return this.code;
    }

    public String getState() {
        return this.state;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setState(String state) {
        this.state = state;
    }

    public static class PublicProcessWebLinkPlatformV3Builder {
        private String customBasePath;
        private String namespace;
        private String platformId;
        private String code;
        private String state;

        PublicProcessWebLinkPlatformV3Builder() {
        }

        public PublicProcessWebLinkPlatformV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PublicProcessWebLinkPlatformV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicProcessWebLinkPlatformV3Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public PublicProcessWebLinkPlatformV3Builder code(String code) {
            this.code = code;
            return this;
        }

        public PublicProcessWebLinkPlatformV3Builder state(String state) {
            this.state = state;
            return this;
        }

        public PublicProcessWebLinkPlatformV3 build() {
            return new PublicProcessWebLinkPlatformV3(this.customBasePath, this.namespace, this.platformId, this.code, this.state);
        }

        public String toString() {
            return "PublicProcessWebLinkPlatformV3.PublicProcessWebLinkPlatformV3Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", platformId=" + this.platformId + ", code=" + this.code + ", state=" + this.state + ")";
        }
    }
}

