/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelGetUsersResponseWithPaginationV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ListAdminsV3
extends Operation {
    private String path = "/iam/v3/admin/namespaces/{namespace}/admins";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String after;
    private String before;
    private String endDate;
    private Integer limit;
    private String query;
    private String roleId;
    private String startDate;

    @Deprecated
    public ListAdminsV3(String customBasePath, String namespace, String after, String before, String endDate, Integer limit, String query, String roleId, String startDate) {
        this.namespace = namespace;
        this.after = after;
        this.before = before;
        this.endDate = endDate;
        this.limit = limit;
        this.query = query;
        this.roleId = roleId;
        this.startDate = startDate;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("after", this.after == null ? null : Arrays.asList(this.after));
        queryParams.put("before", this.before == null ? null : Arrays.asList(this.before));
        queryParams.put("endDate", this.endDate == null ? null : Arrays.asList(this.endDate));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("query", this.query == null ? null : Arrays.asList(this.query));
        queryParams.put("roleId", this.roleId == null ? null : Arrays.asList(this.roleId));
        queryParams.put("startDate", this.startDate == null ? null : Arrays.asList(this.startDate));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ModelGetUsersResponseWithPaginationV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelGetUsersResponseWithPaginationV3().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("after", "None");
        result.put("before", "None");
        result.put("endDate", "None");
        result.put("limit", "None");
        result.put("query", "None");
        result.put("roleId", "None");
        result.put("startDate", "None");
        return result;
    }

    public static ListAdminsV3Builder builder() {
        return new ListAdminsV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getAfter() {
        return this.after;
    }

    public String getBefore() {
        return this.before;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public void setBefore(String before) {
        this.before = before;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public static class ListAdminsV3Builder {
        private String customBasePath;
        private String namespace;
        private String after;
        private String before;
        private String endDate;
        private Integer limit;
        private String query;
        private String roleId;
        private String startDate;

        ListAdminsV3Builder() {
        }

        public ListAdminsV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public ListAdminsV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ListAdminsV3Builder after(String after) {
            this.after = after;
            return this;
        }

        public ListAdminsV3Builder before(String before) {
            this.before = before;
            return this;
        }

        public ListAdminsV3Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public ListAdminsV3Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListAdminsV3Builder query(String query) {
            this.query = query;
            return this;
        }

        public ListAdminsV3Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public ListAdminsV3Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public ListAdminsV3 build() {
            return new ListAdminsV3(this.customBasePath, this.namespace, this.after, this.before, this.endDate, this.limit, this.query, this.roleId, this.startDate);
        }

        public String toString() {
            return "ListAdminsV3.ListAdminsV3Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", after=" + this.after + ", before=" + this.before + ", endDate=" + this.endDate + ", limit=" + this.limit + ", query=" + this.query + ", roleId=" + this.roleId + ", startDate=" + this.startDate + ")";
        }
    }
}

