/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelUserCreateRequestV3;
import net.accelbyte.sdk.api.iam.models.ModelUserCreateResponseV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class CreateUserFromInvitationV3
extends Operation {
    private String path = "/iam/v3/public/namespaces/{namespace}/users/invite/{invitationId}";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String invitationId;
    private String namespace;
    private ModelUserCreateRequestV3 body;

    @Deprecated
    public CreateUserFromInvitationV3(String customBasePath, String invitationId, String namespace, ModelUserCreateRequestV3 body) {
        this.invitationId = invitationId;
        this.namespace = namespace;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.invitationId != null) {
            pathParams.put("invitationId", this.invitationId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ModelUserCreateRequestV3 getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.invitationId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelUserCreateResponseV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 201) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelUserCreateResponseV3().createFromJson(json);
    }

    public static CreateUserFromInvitationV3Builder builder() {
        return new CreateUserFromInvitationV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getInvitationId() {
        return this.invitationId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ModelUserCreateRequestV3 getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setInvitationId(String invitationId) {
        this.invitationId = invitationId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ModelUserCreateRequestV3 body) {
        this.body = body;
    }

    public static class CreateUserFromInvitationV3Builder {
        private String customBasePath;
        private String invitationId;
        private String namespace;
        private ModelUserCreateRequestV3 body;

        CreateUserFromInvitationV3Builder() {
        }

        public CreateUserFromInvitationV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public CreateUserFromInvitationV3Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        public CreateUserFromInvitationV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public CreateUserFromInvitationV3Builder body(ModelUserCreateRequestV3 body) {
            this.body = body;
            return this;
        }

        public CreateUserFromInvitationV3 build() {
            return new CreateUserFromInvitationV3(this.customBasePath, this.invitationId, this.namespace, this.body);
        }

        public String toString() {
            return "CreateUserFromInvitationV3.CreateUserFromInvitationV3Builder(customBasePath=" + this.customBasePath + ", invitationId=" + this.invitationId + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

