/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class CheckUserAvailability
extends Operation {
    private String path = "/iam/v3/public/namespaces/{namespace}/users/availability";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String field;
    private String query;

    @Deprecated
    public CheckUserAvailability(String customBasePath, String namespace, String field, String query) {
        this.namespace = namespace;
        this.field = field;
        this.query = query;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("field", this.field == null ? null : Arrays.asList(this.field));
        queryParams.put("query", this.query == null ? null : Arrays.asList(this.query));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.field == null) {
            return false;
        }
        return this.query != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("field", "None");
        result.put("query", "None");
        return result;
    }

    public static CheckUserAvailabilityBuilder builder() {
        return new CheckUserAvailabilityBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getField() {
        return this.field;
    }

    public String getQuery() {
        return this.query;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public static class CheckUserAvailabilityBuilder {
        private String customBasePath;
        private String namespace;
        private String field;
        private String query;

        CheckUserAvailabilityBuilder() {
        }

        public CheckUserAvailabilityBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public CheckUserAvailabilityBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public CheckUserAvailabilityBuilder field(String field) {
            this.field = field;
            return this;
        }

        public CheckUserAvailabilityBuilder query(String query) {
            this.query = query;
            return this;
        }

        public CheckUserAvailability build() {
            return new CheckUserAvailability(this.customBasePath, this.namespace, this.field, this.query);
        }

        public String toString() {
            return "CheckUserAvailability.CheckUserAvailabilityBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", field=" + this.field + ", query=" + this.query + ")";
        }
    }
}

