/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelBanUpdateRequest;
import net.accelbyte.sdk.api.iam.models.ModelUserBanResponseV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminUpdateUserBanV3
extends Operation {
    private String path = "/iam/v3/admin/namespaces/{namespace}/users/{userId}/bans/{banId}";
    private String method = "PATCH";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String banId;
    private String namespace;
    private String userId;
    private ModelBanUpdateRequest body;

    @Deprecated
    public AdminUpdateUserBanV3(String customBasePath, String banId, String namespace, String userId, ModelBanUpdateRequest body) {
        this.banId = banId;
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.banId != null) {
            pathParams.put("banId", this.banId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public ModelBanUpdateRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.banId == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public ModelUserBanResponseV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelUserBanResponseV3().createFromJson(json);
    }

    public static AdminUpdateUserBanV3Builder builder() {
        return new AdminUpdateUserBanV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getBanId() {
        return this.banId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public ModelBanUpdateRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setBanId(String banId) {
        this.banId = banId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(ModelBanUpdateRequest body) {
        this.body = body;
    }

    public static class AdminUpdateUserBanV3Builder {
        private String customBasePath;
        private String banId;
        private String namespace;
        private String userId;
        private ModelBanUpdateRequest body;

        AdminUpdateUserBanV3Builder() {
        }

        public AdminUpdateUserBanV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminUpdateUserBanV3Builder banId(String banId) {
            this.banId = banId;
            return this;
        }

        public AdminUpdateUserBanV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminUpdateUserBanV3Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AdminUpdateUserBanV3Builder body(ModelBanUpdateRequest body) {
            this.body = body;
            return this;
        }

        public AdminUpdateUserBanV3 build() {
            return new AdminUpdateUserBanV3(this.customBasePath, this.banId, this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "AdminUpdateUserBanV3.AdminUpdateUserBanV3Builder(customBasePath=" + this.customBasePath + ", banId=" + this.banId + ", namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

