/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelSearchUsersResponseWithPaginationV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminSearchUserV3
extends Operation {
    private String path = "/iam/v3/admin/namespaces/{namespace}/users/search";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String by;
    private String endDate;
    private Boolean includeTotal;
    private Integer limit;
    private Integer offset;
    private String platformBy;
    private String platformId;
    private String query;
    private String roleIds;
    private Boolean skipLoginQueue;
    private String startDate;
    private Boolean testAccount;

    @Deprecated
    public AdminSearchUserV3(String customBasePath, String namespace, String by, String endDate, Boolean includeTotal, Integer limit, Integer offset, String platformBy, String platformId, String query, String roleIds, Boolean skipLoginQueue, String startDate, Boolean testAccount) {
        this.namespace = namespace;
        this.by = by;
        this.endDate = endDate;
        this.includeTotal = includeTotal;
        this.limit = limit;
        this.offset = offset;
        this.platformBy = platformBy;
        this.platformId = platformId;
        this.query = query;
        this.roleIds = roleIds;
        this.skipLoginQueue = skipLoginQueue;
        this.startDate = startDate;
        this.testAccount = testAccount;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("by", this.by == null ? null : Arrays.asList(this.by));
        queryParams.put("endDate", this.endDate == null ? null : Arrays.asList(this.endDate));
        queryParams.put("includeTotal", this.includeTotal == null ? null : Arrays.asList(String.valueOf(this.includeTotal)));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("platformBy", this.platformBy == null ? null : Arrays.asList(this.platformBy));
        queryParams.put("platformId", this.platformId == null ? null : Arrays.asList(this.platformId));
        queryParams.put("query", this.query == null ? null : Arrays.asList(this.query));
        queryParams.put("roleIds", this.roleIds == null ? null : Arrays.asList(this.roleIds));
        queryParams.put("skipLoginQueue", this.skipLoginQueue == null ? null : Arrays.asList(String.valueOf(this.skipLoginQueue)));
        queryParams.put("startDate", this.startDate == null ? null : Arrays.asList(this.startDate));
        queryParams.put("testAccount", this.testAccount == null ? null : Arrays.asList(String.valueOf(this.testAccount)));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ModelSearchUsersResponseWithPaginationV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelSearchUsersResponseWithPaginationV3().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("by", "None");
        result.put("endDate", "None");
        result.put("includeTotal", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("platformBy", "None");
        result.put("platformId", "None");
        result.put("query", "None");
        result.put("roleIds", "None");
        result.put("skipLoginQueue", "None");
        result.put("startDate", "None");
        result.put("testAccount", "None");
        return result;
    }

    public static AdminSearchUserV3Builder builder() {
        return new AdminSearchUserV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getBy() {
        return this.by;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public Boolean getIncludeTotal() {
        return this.includeTotal;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getPlatformBy() {
        return this.platformBy;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRoleIds() {
        return this.roleIds;
    }

    public Boolean getSkipLoginQueue() {
        return this.skipLoginQueue;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public Boolean getTestAccount() {
        return this.testAccount;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBy(String by) {
        this.by = by;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setIncludeTotal(Boolean includeTotal) {
        this.includeTotal = includeTotal;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setPlatformBy(String platformBy) {
        this.platformBy = platformBy;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setRoleIds(String roleIds) {
        this.roleIds = roleIds;
    }

    public void setSkipLoginQueue(Boolean skipLoginQueue) {
        this.skipLoginQueue = skipLoginQueue;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setTestAccount(Boolean testAccount) {
        this.testAccount = testAccount;
    }

    public static class AdminSearchUserV3Builder {
        private String customBasePath;
        private String namespace;
        private String by;
        private String endDate;
        private Boolean includeTotal;
        private Integer limit;
        private Integer offset;
        private String platformBy;
        private String platformId;
        private String query;
        private String roleIds;
        private Boolean skipLoginQueue;
        private String startDate;
        private Boolean testAccount;

        AdminSearchUserV3Builder() {
        }

        public AdminSearchUserV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminSearchUserV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminSearchUserV3Builder by(String by) {
            this.by = by;
            return this;
        }

        public AdminSearchUserV3Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public AdminSearchUserV3Builder includeTotal(Boolean includeTotal) {
            this.includeTotal = includeTotal;
            return this;
        }

        public AdminSearchUserV3Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AdminSearchUserV3Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public AdminSearchUserV3Builder platformBy(String platformBy) {
            this.platformBy = platformBy;
            return this;
        }

        public AdminSearchUserV3Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public AdminSearchUserV3Builder query(String query) {
            this.query = query;
            return this;
        }

        public AdminSearchUserV3Builder roleIds(String roleIds) {
            this.roleIds = roleIds;
            return this;
        }

        public AdminSearchUserV3Builder skipLoginQueue(Boolean skipLoginQueue) {
            this.skipLoginQueue = skipLoginQueue;
            return this;
        }

        public AdminSearchUserV3Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public AdminSearchUserV3Builder testAccount(Boolean testAccount) {
            this.testAccount = testAccount;
            return this;
        }

        public AdminSearchUserV3 build() {
            return new AdminSearchUserV3(this.customBasePath, this.namespace, this.by, this.endDate, this.includeTotal, this.limit, this.offset, this.platformBy, this.platformId, this.query, this.roleIds, this.skipLoginQueue, this.startDate, this.testAccount);
        }

        public String toString() {
            return "AdminSearchUserV3.AdminSearchUserV3Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", by=" + this.by + ", endDate=" + this.endDate + ", includeTotal=" + this.includeTotal + ", limit=" + this.limit + ", offset=" + this.offset + ", platformBy=" + this.platformBy + ", platformId=" + this.platformId + ", query=" + this.query + ", roleIds=" + this.roleIds + ", skipLoginQueue=" + this.skipLoginQueue + ", startDate=" + this.startDate + ", testAccount=" + this.testAccount + ")";
        }
    }
}

