/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.AccountcommonUserPlatforms;
import net.accelbyte.sdk.api.iam.models.ModelPlatformUserIDRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminListUserIDByPlatformUserIDsV3
extends Operation {
    private String path = "/iam/v3/admin/namespaces/{namespace}/platforms/{platformId}/users";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String platformId;
    private Boolean rawPID;
    private Boolean rawPUID;
    private ModelPlatformUserIDRequest body;

    @Deprecated
    public AdminListUserIDByPlatformUserIDsV3(String customBasePath, String namespace, String platformId, Boolean rawPID, Boolean rawPUID, ModelPlatformUserIDRequest body) {
        this.namespace = namespace;
        this.platformId = platformId;
        this.rawPID = rawPID;
        this.rawPUID = rawPUID;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.platformId != null) {
            pathParams.put("platformId", this.platformId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("rawPID", this.rawPID == null ? null : Arrays.asList(String.valueOf(this.rawPID)));
        queryParams.put("rawPUID", this.rawPUID == null ? null : Arrays.asList(String.valueOf(this.rawPUID)));
        return queryParams;
    }

    public ModelPlatformUserIDRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.platformId != null;
    }

    public AccountcommonUserPlatforms parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new AccountcommonUserPlatforms().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("rawPID", "None");
        result.put("rawPUID", "None");
        return result;
    }

    public static AdminListUserIDByPlatformUserIDsV3Builder builder() {
        return new AdminListUserIDByPlatformUserIDsV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public Boolean getRawPID() {
        return this.rawPID;
    }

    public Boolean getRawPUID() {
        return this.rawPUID;
    }

    public ModelPlatformUserIDRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setRawPID(Boolean rawPID) {
        this.rawPID = rawPID;
    }

    public void setRawPUID(Boolean rawPUID) {
        this.rawPUID = rawPUID;
    }

    public void setBody(ModelPlatformUserIDRequest body) {
        this.body = body;
    }

    public static class AdminListUserIDByPlatformUserIDsV3Builder {
        private String customBasePath;
        private String namespace;
        private String platformId;
        private Boolean rawPID;
        private Boolean rawPUID;
        private ModelPlatformUserIDRequest body;

        AdminListUserIDByPlatformUserIDsV3Builder() {
        }

        public AdminListUserIDByPlatformUserIDsV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminListUserIDByPlatformUserIDsV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminListUserIDByPlatformUserIDsV3Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public AdminListUserIDByPlatformUserIDsV3Builder rawPID(Boolean rawPID) {
            this.rawPID = rawPID;
            return this;
        }

        public AdminListUserIDByPlatformUserIDsV3Builder rawPUID(Boolean rawPUID) {
            this.rawPUID = rawPUID;
            return this;
        }

        public AdminListUserIDByPlatformUserIDsV3Builder body(ModelPlatformUserIDRequest body) {
            this.body = body;
            return this;
        }

        public AdminListUserIDByPlatformUserIDsV3 build() {
            return new AdminListUserIDByPlatformUserIDsV3(this.customBasePath, this.namespace, this.platformId, this.rawPID, this.rawPUID, this.body);
        }

        public String toString() {
            return "AdminListUserIDByPlatformUserIDsV3.AdminListUserIDByPlatformUserIDsV3Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", platformId=" + this.platformId + ", rawPID=" + this.rawPID + ", rawPUID=" + this.rawPUID + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

