/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelUserPlatformMetadata;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetUserSinglePlatformAccount
extends Operation {
    private String path = "/iam/v3/admin/namespaces/{namespace}/users/{userId}/platforms/{platformId}/metadata";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String platformId;
    private String userId;
    private Boolean crossNamespace;

    @Deprecated
    public AdminGetUserSinglePlatformAccount(String customBasePath, String namespace, String platformId, String userId, Boolean crossNamespace) {
        this.namespace = namespace;
        this.platformId = platformId;
        this.userId = userId;
        this.crossNamespace = crossNamespace;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.platformId != null) {
            pathParams.put("platformId", this.platformId);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("crossNamespace", this.crossNamespace == null ? null : Arrays.asList(String.valueOf(this.crossNamespace)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.platformId == null) {
            return false;
        }
        return this.userId != null;
    }

    public ModelUserPlatformMetadata parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelUserPlatformMetadata().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("crossNamespace", "None");
        return result;
    }

    public static AdminGetUserSinglePlatformAccountBuilder builder() {
        return new AdminGetUserSinglePlatformAccountBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Boolean getCrossNamespace() {
        return this.crossNamespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setCrossNamespace(Boolean crossNamespace) {
        this.crossNamespace = crossNamespace;
    }

    public static class AdminGetUserSinglePlatformAccountBuilder {
        private String customBasePath;
        private String namespace;
        private String platformId;
        private String userId;
        private Boolean crossNamespace;

        AdminGetUserSinglePlatformAccountBuilder() {
        }

        public AdminGetUserSinglePlatformAccountBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminGetUserSinglePlatformAccountBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminGetUserSinglePlatformAccountBuilder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public AdminGetUserSinglePlatformAccountBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AdminGetUserSinglePlatformAccountBuilder crossNamespace(Boolean crossNamespace) {
            this.crossNamespace = crossNamespace;
            return this;
        }

        public AdminGetUserSinglePlatformAccount build() {
            return new AdminGetUserSinglePlatformAccount(this.customBasePath, this.namespace, this.platformId, this.userId, this.crossNamespace);
        }

        public String toString() {
            return "AdminGetUserSinglePlatformAccount.AdminGetUserSinglePlatformAccountBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", platformId=" + this.platformId + ", userId=" + this.userId + ", crossNamespace=" + this.crossNamespace + ")";
        }
    }
}

