/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelGetUserMappingV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetUserMapping
extends Operation {
    private String path = "/iam/v3/admin/namespaces/{namespace}/users/{userId}/platforms/justice/{targetNamespace}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String targetNamespace;
    private String userId;

    @Deprecated
    public AdminGetUserMapping(String customBasePath, String namespace, String targetNamespace, String userId) {
        this.namespace = namespace;
        this.targetNamespace = targetNamespace;
        this.userId = userId;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.targetNamespace != null) {
            pathParams.put("targetNamespace", this.targetNamespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.targetNamespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public ModelGetUserMappingV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelGetUserMappingV3().createFromJson(json);
    }

    public static AdminGetUserMappingBuilder builder() {
        return new AdminGetUserMappingBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class AdminGetUserMappingBuilder {
        private String customBasePath;
        private String namespace;
        private String targetNamespace;
        private String userId;

        AdminGetUserMappingBuilder() {
        }

        public AdminGetUserMappingBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminGetUserMappingBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminGetUserMappingBuilder targetNamespace(String targetNamespace) {
            this.targetNamespace = targetNamespace;
            return this;
        }

        public AdminGetUserMappingBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AdminGetUserMapping build() {
            return new AdminGetUserMapping(this.customBasePath, this.namespace, this.targetNamespace, this.userId);
        }

        public String toString() {
            return "AdminGetUserMapping.AdminGetUserMappingBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", targetNamespace=" + this.targetNamespace + ", userId=" + this.userId + ")";
        }
    }
}

