/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelUserPlatformLinkHistories;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetUserLinkHistoriesV3
extends Operation {
    private String path = "/iam/v3/admin/namespaces/{namespace}/users/{userId}/platforms/link/histories";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private String platformId;

    @Deprecated
    public AdminGetUserLinkHistoriesV3(String customBasePath, String namespace, String userId, String platformId) {
        this.namespace = namespace;
        this.userId = userId;
        this.platformId = platformId;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("platformId", this.platformId == null ? null : Arrays.asList(this.platformId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.userId == null) {
            return false;
        }
        return this.platformId != null;
    }

    public ModelUserPlatformLinkHistories parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelUserPlatformLinkHistories().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("platformId", "None");
        return result;
    }

    public static AdminGetUserLinkHistoriesV3Builder builder() {
        return new AdminGetUserLinkHistoriesV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public static class AdminGetUserLinkHistoriesV3Builder {
        private String customBasePath;
        private String namespace;
        private String userId;
        private String platformId;

        AdminGetUserLinkHistoriesV3Builder() {
        }

        public AdminGetUserLinkHistoriesV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminGetUserLinkHistoriesV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminGetUserLinkHistoriesV3Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AdminGetUserLinkHistoriesV3Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public AdminGetUserLinkHistoriesV3 build() {
            return new AdminGetUserLinkHistoriesV3(this.customBasePath, this.namespace, this.userId, this.platformId);
        }

        public String toString() {
            return "AdminGetUserLinkHistoriesV3.AdminGetUserLinkHistoriesV3Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", userId=" + this.userId + ", platformId=" + this.platformId + ")";
        }
    }
}

