/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelGetBulkUserBansRequest;
import net.accelbyte.sdk.api.iam.models.ModelGetUserBanV3Response;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetBulkUserBanV3
extends Operation {
    private String path = "/iam/v3/admin/namespaces/{namespace}/users/bans";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Boolean activeOnly;
    private String banType;
    private ModelGetBulkUserBansRequest body;

    @Deprecated
    public AdminGetBulkUserBanV3(String customBasePath, String namespace, Boolean activeOnly, String banType, ModelGetBulkUserBansRequest body) {
        this.namespace = namespace;
        this.activeOnly = activeOnly;
        this.banType = banType;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("activeOnly", this.activeOnly == null ? null : Arrays.asList(String.valueOf(this.activeOnly)));
        queryParams.put("banType", this.banType == null ? null : Arrays.asList(this.banType));
        return queryParams;
    }

    public ModelGetBulkUserBansRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ModelGetUserBanV3Response parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelGetUserBanV3Response().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("activeOnly", "None");
        result.put("banType", "None");
        return result;
    }

    public static AdminGetBulkUserBanV3Builder builder() {
        return new AdminGetBulkUserBanV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getActiveOnly() {
        return this.activeOnly;
    }

    public String getBanType() {
        return this.banType;
    }

    public ModelGetBulkUserBansRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setActiveOnly(Boolean activeOnly) {
        this.activeOnly = activeOnly;
    }

    public void setBanType(String banType) {
        this.banType = banType;
    }

    public void setBody(ModelGetBulkUserBansRequest body) {
        this.body = body;
    }

    public static class AdminGetBulkUserBanV3Builder {
        private String customBasePath;
        private String namespace;
        private Boolean activeOnly;
        private String banType;
        private ModelGetBulkUserBansRequest body;

        AdminGetBulkUserBanV3Builder() {
        }

        public AdminGetBulkUserBanV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminGetBulkUserBanV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminGetBulkUserBanV3Builder activeOnly(Boolean activeOnly) {
            this.activeOnly = activeOnly;
            return this;
        }

        public AdminGetBulkUserBanV3Builder banType(String banType) {
            this.banType = banType;
            return this;
        }

        public AdminGetBulkUserBanV3Builder body(ModelGetBulkUserBansRequest body) {
            this.body = body;
            return this;
        }

        public AdminGetBulkUserBanV3 build() {
            return new AdminGetBulkUserBanV3(this.customBasePath, this.namespace, this.activeOnly, this.banType, this.body);
        }

        public String toString() {
            return "AdminGetBulkUserBanV3.AdminGetBulkUserBanV3Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", activeOnly=" + this.activeOnly + ", banType=" + this.banType + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

