/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.third_party_credential;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelPublicThirdPartyPlatformInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RetrieveActiveOIDCClientsPublicV3
extends Operation {
    private String path = "/iam/v3/public/namespaces/{namespace}/platforms/clients/oidc";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String clientId;

    @Deprecated
    public RetrieveActiveOIDCClientsPublicV3(String customBasePath, String namespace, String clientId) {
        this.namespace = namespace;
        this.clientId = clientId;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("clientId", this.clientId == null ? null : Arrays.asList(this.clientId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.clientId != null;
    }

    public List<ModelPublicThirdPartyPlatformInfo> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<ModelPublicThirdPartyPlatformInfo>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("clientId", "None");
        return result;
    }

    public static RetrieveActiveOIDCClientsPublicV3Builder builder() {
        return new RetrieveActiveOIDCClientsPublicV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public static class RetrieveActiveOIDCClientsPublicV3Builder {
        private String customBasePath;
        private String namespace;
        private String clientId;

        RetrieveActiveOIDCClientsPublicV3Builder() {
        }

        public RetrieveActiveOIDCClientsPublicV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public RetrieveActiveOIDCClientsPublicV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RetrieveActiveOIDCClientsPublicV3Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public RetrieveActiveOIDCClientsPublicV3 build() {
            return new RetrieveActiveOIDCClientsPublicV3(this.customBasePath, this.namespace, this.clientId);
        }

        public String toString() {
            return "RetrieveActiveOIDCClientsPublicV3.RetrieveActiveOIDCClientsPublicV3Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", clientId=" + this.clientId + ")";
        }
    }
}

