/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.sso_saml_2_0;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PlatformAuthenticateSAMLV3Handler
extends Operation {
    private String path = "/iam/v3/sso/saml/platforms/{platformId}/authenticate";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList(new String[0]);
    private String locationQuery = "PLACEHOLDER";
    private String platformId;
    private String code;
    private String error;
    private String state;

    @Deprecated
    public PlatformAuthenticateSAMLV3Handler(String customBasePath, String platformId, String code, String error, String state) {
        this.platformId = platformId;
        this.code = code;
        this.error = error;
        this.state = state;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.platformId != null) {
            pathParams.put("platformId", this.platformId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("code", this.code == null ? null : Arrays.asList(this.code));
        queryParams.put("error", this.error == null ? null : Arrays.asList(this.error));
        queryParams.put("state", this.state == null ? null : Arrays.asList(this.state));
        return queryParams;
    }

    public boolean isValid() {
        if (this.platformId == null) {
            return false;
        }
        return this.state != null;
    }

    public String parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        String json = Helper.convertInputStreamToString((InputStream)payload);
        if (code != 302) {
            throw new HttpResponseException(code, json);
        }
        return json;
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("code", "None");
        result.put("error", "None");
        result.put("state", "None");
        return result;
    }

    public static PlatformAuthenticateSAMLV3HandlerBuilder builder() {
        return new PlatformAuthenticateSAMLV3HandlerBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public String getCode() {
        return this.code;
    }

    public String getError() {
        return this.error;
    }

    public String getState() {
        return this.state;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setState(String state) {
        this.state = state;
    }

    public static class PlatformAuthenticateSAMLV3HandlerBuilder {
        private String customBasePath;
        private String platformId;
        private String code;
        private String error;
        private String state;

        PlatformAuthenticateSAMLV3HandlerBuilder() {
        }

        public PlatformAuthenticateSAMLV3HandlerBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PlatformAuthenticateSAMLV3HandlerBuilder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public PlatformAuthenticateSAMLV3HandlerBuilder code(String code) {
            this.code = code;
            return this;
        }

        public PlatformAuthenticateSAMLV3HandlerBuilder error(String error) {
            this.error = error;
            return this;
        }

        public PlatformAuthenticateSAMLV3HandlerBuilder state(String state) {
            this.state = state;
            return this;
        }

        public PlatformAuthenticateSAMLV3Handler build() {
            return new PlatformAuthenticateSAMLV3Handler(this.customBasePath, this.platformId, this.code, this.error, this.state);
        }

        public String toString() {
            return "PlatformAuthenticateSAMLV3Handler.PlatformAuthenticateSAMLV3HandlerBuilder(customBasePath=" + this.customBasePath + ", platformId=" + this.platformId + ", code=" + this.code + ", error=" + this.error + ", state=" + this.state + ")";
        }
    }
}

