/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.sso;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class LoginSSOClient
extends Operation {
    private String path = "/iam/v3/sso/{platformId}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String platformId;
    private String payload;

    @Deprecated
    public LoginSSOClient(String customBasePath, String platformId, String payload) {
        this.platformId = platformId;
        this.payload = payload;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.platformId != null) {
            pathParams.put("platformId", this.platformId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("payload", this.payload == null ? null : Arrays.asList(this.payload));
        return queryParams;
    }

    public boolean isValid() {
        return this.platformId != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("payload", "None");
        return result;
    }

    public static LoginSSOClientBuilder builder() {
        return new LoginSSOClientBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public static class LoginSSOClientBuilder {
        private String customBasePath;
        private String platformId;
        private String payload;

        LoginSSOClientBuilder() {
        }

        public LoginSSOClientBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public LoginSSOClientBuilder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public LoginSSOClientBuilder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public LoginSSOClient build() {
            return new LoginSSOClient(this.customBasePath, this.platformId, this.payload);
        }

        public String toString() {
            return "LoginSSOClient.LoginSSOClientBuilder(customBasePath=" + this.customBasePath + ", platformId=" + this.platformId + ", payload=" + this.payload + ")";
        }
    }
}

