/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.roles;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelRoleNamesResponseV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetRolesV3
extends Operation {
    private String path = "/iam/v3/public/roles";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String after;
    private String before;
    private Boolean isWildcard;
    private Integer limit;

    @Deprecated
    public PublicGetRolesV3(String customBasePath, String after, String before, Boolean isWildcard, Integer limit) {
        this.after = after;
        this.before = before;
        this.isWildcard = isWildcard;
        this.limit = limit;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("after", this.after == null ? null : Arrays.asList(this.after));
        queryParams.put("before", this.before == null ? null : Arrays.asList(this.before));
        queryParams.put("isWildcard", this.isWildcard == null ? null : Arrays.asList(String.valueOf(this.isWildcard)));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        return queryParams;
    }

    public boolean isValid() {
        return true;
    }

    public ModelRoleNamesResponseV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelRoleNamesResponseV3().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("after", "None");
        result.put("before", "None");
        result.put("isWildcard", "None");
        result.put("limit", "None");
        return result;
    }

    public static PublicGetRolesV3Builder builder() {
        return new PublicGetRolesV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getAfter() {
        return this.after;
    }

    public String getBefore() {
        return this.before;
    }

    public Boolean getIsWildcard() {
        return this.isWildcard;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public void setBefore(String before) {
        this.before = before;
    }

    public void setIsWildcard(Boolean isWildcard) {
        this.isWildcard = isWildcard;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public static class PublicGetRolesV3Builder {
        private String customBasePath;
        private String after;
        private String before;
        private Boolean isWildcard;
        private Integer limit;

        PublicGetRolesV3Builder() {
        }

        public PublicGetRolesV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PublicGetRolesV3Builder after(String after) {
            this.after = after;
            return this;
        }

        public PublicGetRolesV3Builder before(String before) {
            this.before = before;
            return this;
        }

        public PublicGetRolesV3Builder isWildcard(Boolean isWildcard) {
            this.isWildcard = isWildcard;
            return this;
        }

        public PublicGetRolesV3Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PublicGetRolesV3 build() {
            return new PublicGetRolesV3(this.customBasePath, this.after, this.before, this.isWildcard, this.limit);
        }

        public String toString() {
            return "PublicGetRolesV3.PublicGetRolesV3Builder(customBasePath=" + this.customBasePath + ", after=" + this.after + ", before=" + this.before + ", isWildcard=" + this.isWildcard + ", limit=" + this.limit + ")";
        }
    }
}

