/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.roles;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelListRoleV4Response;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetRolesV4
extends Operation {
    private String path = "/iam/v4/admin/roles";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private Boolean adminRole;
    private Boolean isWildcard;
    private Integer limit;
    private Integer offset;

    @Deprecated
    public AdminGetRolesV4(String customBasePath, Boolean adminRole, Boolean isWildcard, Integer limit, Integer offset) {
        this.adminRole = adminRole;
        this.isWildcard = isWildcard;
        this.limit = limit;
        this.offset = offset;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("adminRole", this.adminRole == null ? null : Arrays.asList(String.valueOf(this.adminRole)));
        queryParams.put("isWildcard", this.isWildcard == null ? null : Arrays.asList(String.valueOf(this.isWildcard)));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        return queryParams;
    }

    public boolean isValid() {
        return true;
    }

    public ModelListRoleV4Response parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelListRoleV4Response().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("adminRole", "None");
        result.put("isWildcard", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        return result;
    }

    public static AdminGetRolesV4Builder builder() {
        return new AdminGetRolesV4Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public Boolean getAdminRole() {
        return this.adminRole;
    }

    public Boolean getIsWildcard() {
        return this.isWildcard;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setAdminRole(Boolean adminRole) {
        this.adminRole = adminRole;
    }

    public void setIsWildcard(Boolean isWildcard) {
        this.isWildcard = isWildcard;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public static class AdminGetRolesV4Builder {
        private String customBasePath;
        private Boolean adminRole;
        private Boolean isWildcard;
        private Integer limit;
        private Integer offset;

        AdminGetRolesV4Builder() {
        }

        public AdminGetRolesV4Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminGetRolesV4Builder adminRole(Boolean adminRole) {
            this.adminRole = adminRole;
            return this;
        }

        public AdminGetRolesV4Builder isWildcard(Boolean isWildcard) {
            this.isWildcard = isWildcard;
            return this;
        }

        public AdminGetRolesV4Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AdminGetRolesV4Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public AdminGetRolesV4 build() {
            return new AdminGetRolesV4(this.customBasePath, this.adminRole, this.isWildcard, this.limit, this.offset);
        }

        public String toString() {
            return "AdminGetRolesV4.AdminGetRolesV4Builder(customBasePath=" + this.customBasePath + ", adminRole=" + this.adminRole + ", isWildcard=" + this.isWildcard + ", limit=" + this.limit + ", offset=" + this.offset + ")";
        }
    }
}

