/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.override_role_config_v3;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelRoleOverrideResponse;
import net.accelbyte.sdk.api.iam.models.ModelRoleOverrideUpdateRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminUpdateRoleOverrideConfigV3
extends Operation {
    private String path = "/iam/v3/admin/namespaces/{namespace}/roleoverride";
    private String method = "PATCH";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String identity;
    private ModelRoleOverrideUpdateRequest body;

    @Deprecated
    public AdminUpdateRoleOverrideConfigV3(String customBasePath, String namespace, String identity, ModelRoleOverrideUpdateRequest body) {
        this.namespace = namespace;
        this.identity = identity;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("identity", this.identity == null ? null : Arrays.asList(this.identity));
        return queryParams;
    }

    public ModelRoleOverrideUpdateRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.identity != null;
    }

    public ModelRoleOverrideResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelRoleOverrideResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("identity", "None");
        return result;
    }

    public static AdminUpdateRoleOverrideConfigV3Builder builder() {
        return new AdminUpdateRoleOverrideConfigV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getIdentity() {
        return this.identity;
    }

    public ModelRoleOverrideUpdateRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setBody(ModelRoleOverrideUpdateRequest body) {
        this.body = body;
    }

    public static class AdminUpdateRoleOverrideConfigV3Builder {
        private String customBasePath;
        private String namespace;
        private ModelRoleOverrideUpdateRequest body;
        private String identity;

        public AdminUpdateRoleOverrideConfigV3Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public AdminUpdateRoleOverrideConfigV3Builder identityFromEnum(Identity identity) {
            this.identity = identity.toString();
            return this;
        }

        AdminUpdateRoleOverrideConfigV3Builder() {
        }

        public AdminUpdateRoleOverrideConfigV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminUpdateRoleOverrideConfigV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminUpdateRoleOverrideConfigV3Builder body(ModelRoleOverrideUpdateRequest body) {
            this.body = body;
            return this;
        }

        public AdminUpdateRoleOverrideConfigV3 build() {
            return new AdminUpdateRoleOverrideConfigV3(this.customBasePath, this.namespace, this.identity, this.body);
        }

        public String toString() {
            return "AdminUpdateRoleOverrideConfigV3.AdminUpdateRoleOverrideConfigV3Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", identity=" + this.identity + ", body=" + (Object)((Object)this.body) + ")";
        }
    }

    public static enum Identity {
        GAMEADMIN("GAME_ADMIN"),
        USER("USER"),
        VIEWONLY("VIEW_ONLY");

        private String value;

        private Identity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

