/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0_v4;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenResponseV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class Verify2faCodeV4
extends Operation {
    private String path = "/iam/v4/oauth/mfa/verify";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String code;
    private String factor;
    private String mfaToken;
    private Boolean rememberDevice;

    @Deprecated
    public Verify2faCodeV4(String customBasePath, String code, String factor, String mfaToken, Boolean rememberDevice) {
        this.code = code;
        this.factor = factor;
        this.mfaToken = mfaToken;
        this.rememberDevice = rememberDevice;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.code != null) {
            formDataParams.put("code", this.code);
        }
        if (this.factor != null) {
            formDataParams.put("factor", this.factor);
        }
        if (this.mfaToken != null) {
            formDataParams.put("mfaToken", this.mfaToken);
        }
        if (this.rememberDevice != null) {
            formDataParams.put("rememberDevice", this.rememberDevice == null ? null : String.valueOf(this.rememberDevice));
        }
        return formDataParams;
    }

    public boolean isValid() {
        if (this.code == null) {
            return false;
        }
        if (this.factor == null) {
            return false;
        }
        if (this.mfaToken == null) {
            return false;
        }
        return this.rememberDevice != null;
    }

    public OauthmodelTokenResponseV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OauthmodelTokenResponseV3().createFromJson(json);
    }

    public static Verify2faCodeV4Builder builder() {
        return new Verify2faCodeV4Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCode() {
        return this.code;
    }

    public String getFactor() {
        return this.factor;
    }

    public String getMfaToken() {
        return this.mfaToken;
    }

    public Boolean getRememberDevice() {
        return this.rememberDevice;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setFactor(String factor) {
        this.factor = factor;
    }

    public void setMfaToken(String mfaToken) {
        this.mfaToken = mfaToken;
    }

    public void setRememberDevice(Boolean rememberDevice) {
        this.rememberDevice = rememberDevice;
    }

    public static class Verify2faCodeV4Builder {
        private String customBasePath;
        private String code;
        private String factor;
        private String mfaToken;
        private Boolean rememberDevice;

        Verify2faCodeV4Builder() {
        }

        public Verify2faCodeV4Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public Verify2faCodeV4Builder code(String code) {
            this.code = code;
            return this;
        }

        public Verify2faCodeV4Builder factor(String factor) {
            this.factor = factor;
            return this;
        }

        public Verify2faCodeV4Builder mfaToken(String mfaToken) {
            this.mfaToken = mfaToken;
            return this;
        }

        public Verify2faCodeV4Builder rememberDevice(Boolean rememberDevice) {
            this.rememberDevice = rememberDevice;
            return this;
        }

        public Verify2faCodeV4 build() {
            return new Verify2faCodeV4(this.customBasePath, this.code, this.factor, this.mfaToken, this.rememberDevice);
        }

        public String toString() {
            return "Verify2faCodeV4.Verify2faCodeV4Builder(customBasePath=" + this.customBasePath + ", code=" + this.code + ", factor=" + this.factor + ", mfaToken=" + this.mfaToken + ", rememberDevice=" + this.rememberDevice + ")";
        }
    }
}

