/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0_v4;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenResponseV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class SimultaneousLoginV4
extends Operation {
    private String path = "/iam/v4/oauth/simultaneousLogin";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String simultaneousPlatform;
    private String simultaneousTicket;
    private String nativePlatform;
    private String nativePlatformTicket;

    @Deprecated
    public SimultaneousLoginV4(String customBasePath, String codeChallenge, String codeChallengeMethod, String simultaneousPlatform, String simultaneousTicket, String nativePlatform, String nativePlatformTicket) {
        this.codeChallenge = codeChallenge;
        this.codeChallengeMethod = codeChallengeMethod;
        this.simultaneousPlatform = simultaneousPlatform;
        this.simultaneousTicket = simultaneousTicket;
        this.nativePlatform = nativePlatform;
        this.nativePlatformTicket = nativePlatformTicket;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("code_challenge", this.codeChallenge == null ? null : Arrays.asList(this.codeChallenge));
        queryParams.put("code_challenge_method", this.codeChallengeMethod == null ? null : Arrays.asList(this.codeChallengeMethod));
        return queryParams;
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.simultaneousPlatform != null) {
            formDataParams.put("simultaneousPlatform", this.simultaneousPlatform);
        }
        if (this.simultaneousTicket != null) {
            formDataParams.put("simultaneousTicket", this.simultaneousTicket);
        }
        if (this.nativePlatform != null) {
            formDataParams.put("nativePlatform", this.nativePlatform);
        }
        if (this.nativePlatformTicket != null) {
            formDataParams.put("nativePlatformTicket", this.nativePlatformTicket);
        }
        return formDataParams;
    }

    public boolean isValid() {
        if (this.nativePlatform == null) {
            return false;
        }
        return this.nativePlatformTicket != null;
    }

    public OauthmodelTokenResponseV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OauthmodelTokenResponseV3().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("code_challenge", "None");
        result.put("code_challenge_method", "None");
        return result;
    }

    public static SimultaneousLoginV4Builder builder() {
        return new SimultaneousLoginV4Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public String getSimultaneousPlatform() {
        return this.simultaneousPlatform;
    }

    public String getSimultaneousTicket() {
        return this.simultaneousTicket;
    }

    public String getNativePlatform() {
        return this.nativePlatform;
    }

    public String getNativePlatformTicket() {
        return this.nativePlatformTicket;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public void setSimultaneousPlatform(String simultaneousPlatform) {
        this.simultaneousPlatform = simultaneousPlatform;
    }

    public void setSimultaneousTicket(String simultaneousTicket) {
        this.simultaneousTicket = simultaneousTicket;
    }

    public void setNativePlatform(String nativePlatform) {
        this.nativePlatform = nativePlatform;
    }

    public void setNativePlatformTicket(String nativePlatformTicket) {
        this.nativePlatformTicket = nativePlatformTicket;
    }

    public static class SimultaneousLoginV4Builder {
        private String customBasePath;
        private String codeChallenge;
        private String simultaneousPlatform;
        private String simultaneousTicket;
        private String nativePlatformTicket;
        private String nativePlatform;
        private String codeChallengeMethod;

        public SimultaneousLoginV4Builder nativePlatform(String nativePlatform) {
            this.nativePlatform = nativePlatform;
            return this;
        }

        public SimultaneousLoginV4Builder nativePlatformFromEnum(NativePlatform nativePlatform) {
            this.nativePlatform = nativePlatform.toString();
            return this;
        }

        public SimultaneousLoginV4Builder codeChallengeMethod(String codeChallengeMethod) {
            this.codeChallengeMethod = codeChallengeMethod;
            return this;
        }

        public SimultaneousLoginV4Builder codeChallengeMethodFromEnum(CodeChallengeMethod codeChallengeMethod) {
            this.codeChallengeMethod = codeChallengeMethod.toString();
            return this;
        }

        SimultaneousLoginV4Builder() {
        }

        public SimultaneousLoginV4Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public SimultaneousLoginV4Builder codeChallenge(String codeChallenge) {
            this.codeChallenge = codeChallenge;
            return this;
        }

        public SimultaneousLoginV4Builder simultaneousPlatform(String simultaneousPlatform) {
            this.simultaneousPlatform = simultaneousPlatform;
            return this;
        }

        public SimultaneousLoginV4Builder simultaneousTicket(String simultaneousTicket) {
            this.simultaneousTicket = simultaneousTicket;
            return this;
        }

        public SimultaneousLoginV4Builder nativePlatformTicket(String nativePlatformTicket) {
            this.nativePlatformTicket = nativePlatformTicket;
            return this;
        }

        public SimultaneousLoginV4 build() {
            return new SimultaneousLoginV4(this.customBasePath, this.codeChallenge, this.codeChallengeMethod, this.simultaneousPlatform, this.simultaneousTicket, this.nativePlatform, this.nativePlatformTicket);
        }

        public String toString() {
            return "SimultaneousLoginV4.SimultaneousLoginV4Builder(customBasePath=" + this.customBasePath + ", codeChallenge=" + this.codeChallenge + ", codeChallengeMethod=" + this.codeChallengeMethod + ", simultaneousPlatform=" + this.simultaneousPlatform + ", simultaneousTicket=" + this.simultaneousTicket + ", nativePlatform=" + this.nativePlatform + ", nativePlatformTicket=" + this.nativePlatformTicket + ")";
        }
    }

    public static enum CodeChallengeMethod {
        S256("S256"),
        Plain("plain");

        private String value;

        private CodeChallengeMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum NativePlatform {
        Epicgames("epicgames"),
        Steam("steam");

        private String value;

        private NativePlatform(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

