/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0_v4;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenResponseV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RequestTargetTokenResponseV4
extends Operation {
    private String path = "/iam/v4/oauth/token/exchange";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String additionalData;
    private String code;

    @Deprecated
    public RequestTargetTokenResponseV4(String customBasePath, String additionalData, String code) {
        this.additionalData = additionalData;
        this.code = code;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.additionalData != null) {
            formDataParams.put("additionalData", this.additionalData);
        }
        if (this.code != null) {
            formDataParams.put("code", this.code);
        }
        return formDataParams;
    }

    public boolean isValid() {
        return this.code != null;
    }

    public OauthmodelTokenResponseV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OauthmodelTokenResponseV3().createFromJson(json);
    }

    public static RequestTargetTokenResponseV4Builder builder() {
        return new RequestTargetTokenResponseV4Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public String getCode() {
        return this.code;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static class RequestTargetTokenResponseV4Builder {
        private String customBasePath;
        private String additionalData;
        private String code;

        RequestTargetTokenResponseV4Builder() {
        }

        public RequestTargetTokenResponseV4Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public RequestTargetTokenResponseV4Builder additionalData(String additionalData) {
            this.additionalData = additionalData;
            return this;
        }

        public RequestTargetTokenResponseV4Builder code(String code) {
            this.code = code;
            return this;
        }

        public RequestTargetTokenResponseV4 build() {
            return new RequestTargetTokenResponseV4(this.customBasePath, this.additionalData, this.code);
        }

        public String toString() {
            return "RequestTargetTokenResponseV4.RequestTargetTokenResponseV4Builder(customBasePath=" + this.customBasePath + ", additionalData=" + this.additionalData + ", code=" + this.code + ")";
        }
    }
}

