/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UserAuthenticationV3
extends Operation {
    private String path = "/iam/v3/authenticate";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = "code";
    private String clientId;
    private Boolean extendExp;
    private String redirectUri;
    private String password;
    private String requestId;
    private String userName;

    @Deprecated
    public UserAuthenticationV3(String customBasePath, String clientId, Boolean extendExp, String redirectUri, String password, String requestId, String userName) {
        this.clientId = clientId;
        this.extendExp = extendExp;
        this.redirectUri = redirectUri;
        this.password = password;
        this.requestId = requestId;
        this.userName = userName;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Basic");
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.clientId != null) {
            formDataParams.put("client_id", this.clientId);
        }
        if (this.extendExp != null) {
            formDataParams.put("extend_exp", this.extendExp == null ? null : String.valueOf(this.extendExp));
        }
        if (this.redirectUri != null) {
            formDataParams.put("redirect_uri", this.redirectUri);
        }
        if (this.password != null) {
            formDataParams.put("password", this.password);
        }
        if (this.requestId != null) {
            formDataParams.put("request_id", this.requestId);
        }
        if (this.userName != null) {
            formDataParams.put("user_name", this.userName);
        }
        return formDataParams;
    }

    public boolean isValid() {
        if (this.password == null) {
            return false;
        }
        if (this.requestId == null) {
            return false;
        }
        return this.userName != null;
    }

    public String parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        String json = Helper.convertInputStreamToString((InputStream)payload);
        if (code != 302) {
            throw new HttpResponseException(code, json);
        }
        return json;
    }

    public static UserAuthenticationV3Builder builder() {
        return new UserAuthenticationV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Boolean getExtendExp() {
        return this.extendExp;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setExtendExp(Boolean extendExp) {
        this.extendExp = extendExp;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public static class UserAuthenticationV3Builder {
        private String customBasePath;
        private String clientId;
        private Boolean extendExp;
        private String redirectUri;
        private String password;
        private String requestId;
        private String userName;

        UserAuthenticationV3Builder() {
        }

        public UserAuthenticationV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public UserAuthenticationV3Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public UserAuthenticationV3Builder extendExp(Boolean extendExp) {
            this.extendExp = extendExp;
            return this;
        }

        public UserAuthenticationV3Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public UserAuthenticationV3Builder password(String password) {
            this.password = password;
            return this;
        }

        public UserAuthenticationV3Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public UserAuthenticationV3Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public UserAuthenticationV3 build() {
            return new UserAuthenticationV3(this.customBasePath, this.clientId, this.extendExp, this.redirectUri, this.password, this.requestId, this.userName);
        }

        public String toString() {
            return "UserAuthenticationV3.UserAuthenticationV3Builder(customBasePath=" + this.customBasePath + ", clientId=" + this.clientId + ", extendExp=" + this.extendExp + ", redirectUri=" + this.redirectUri + ", password=" + this.password + ", requestId=" + this.requestId + ", userName=" + this.userName + ")";
        }
    }
}

