/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.OauthmodelTargetTokenCodeResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RequestTokenExchangeCodeV3
extends Operation {
    private String path = "/iam/v3/namespace/{namespace}/token/request";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String clientId;

    @Deprecated
    public RequestTokenExchangeCodeV3(String customBasePath, String namespace, String codeChallenge, String codeChallengeMethod, String clientId) {
        this.namespace = namespace;
        this.codeChallenge = codeChallenge;
        this.codeChallengeMethod = codeChallengeMethod;
        this.clientId = clientId;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("code_challenge", this.codeChallenge == null ? null : Arrays.asList(this.codeChallenge));
        queryParams.put("code_challenge_method", this.codeChallengeMethod == null ? null : Arrays.asList(this.codeChallengeMethod));
        return queryParams;
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.clientId != null) {
            formDataParams.put("client_id", this.clientId);
        }
        return formDataParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.clientId != null;
    }

    public OauthmodelTargetTokenCodeResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OauthmodelTargetTokenCodeResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("code_challenge", "None");
        result.put("code_challenge_method", "None");
        return result;
    }

    public static RequestTokenExchangeCodeV3Builder builder() {
        return new RequestTokenExchangeCodeV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public static class RequestTokenExchangeCodeV3Builder {
        private String customBasePath;
        private String namespace;
        private String codeChallenge;
        private String clientId;
        private String codeChallengeMethod;

        public RequestTokenExchangeCodeV3Builder codeChallengeMethod(String codeChallengeMethod) {
            this.codeChallengeMethod = codeChallengeMethod;
            return this;
        }

        public RequestTokenExchangeCodeV3Builder codeChallengeMethodFromEnum(CodeChallengeMethod codeChallengeMethod) {
            this.codeChallengeMethod = codeChallengeMethod.toString();
            return this;
        }

        RequestTokenExchangeCodeV3Builder() {
        }

        public RequestTokenExchangeCodeV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public RequestTokenExchangeCodeV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RequestTokenExchangeCodeV3Builder codeChallenge(String codeChallenge) {
            this.codeChallenge = codeChallenge;
            return this;
        }

        public RequestTokenExchangeCodeV3Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public RequestTokenExchangeCodeV3 build() {
            return new RequestTokenExchangeCodeV3(this.customBasePath, this.namespace, this.codeChallenge, this.codeChallengeMethod, this.clientId);
        }

        public String toString() {
            return "RequestTokenExchangeCodeV3.RequestTokenExchangeCodeV3Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", codeChallenge=" + this.codeChallenge + ", codeChallengeMethod=" + this.codeChallengeMethod + ", clientId=" + this.clientId + ")";
        }
    }

    public static enum CodeChallengeMethod {
        S256("S256"),
        Plain("plain");

        private String value;

        private CodeChallengeMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

