/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenResponseV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RequestTokenByOneTimeLinkCodeResponseV3
extends Operation {
    private String path = "/iam/v3/link/token/exchange";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String additionalData;
    private Boolean isTransient;
    private String clientId;
    private String oneTimeLinkCode;

    @Deprecated
    public RequestTokenByOneTimeLinkCodeResponseV3(String customBasePath, String additionalData, Boolean isTransient, String clientId, String oneTimeLinkCode) {
        this.additionalData = additionalData;
        this.isTransient = isTransient;
        this.clientId = clientId;
        this.oneTimeLinkCode = oneTimeLinkCode;
        this.customBasePath = customBasePath != null ? customBasePath : "";
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.additionalData != null) {
            formDataParams.put("additionalData", this.additionalData);
        }
        if (this.isTransient != null) {
            formDataParams.put("isTransient", this.isTransient == null ? null : String.valueOf(this.isTransient));
        }
        if (this.clientId != null) {
            formDataParams.put("client_id", this.clientId);
        }
        if (this.oneTimeLinkCode != null) {
            formDataParams.put("oneTimeLinkCode", this.oneTimeLinkCode);
        }
        return formDataParams;
    }

    public boolean isValid() {
        if (this.clientId == null) {
            return false;
        }
        return this.oneTimeLinkCode != null;
    }

    public OauthmodelTokenResponseV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OauthmodelTokenResponseV3().createFromJson(json);
    }

    public static RequestTokenByOneTimeLinkCodeResponseV3Builder builder() {
        return new RequestTokenByOneTimeLinkCodeResponseV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public Boolean getIsTransient() {
        return this.isTransient;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getOneTimeLinkCode() {
        return this.oneTimeLinkCode;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    public void setIsTransient(Boolean isTransient) {
        this.isTransient = isTransient;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setOneTimeLinkCode(String oneTimeLinkCode) {
        this.oneTimeLinkCode = oneTimeLinkCode;
    }

    public static class RequestTokenByOneTimeLinkCodeResponseV3Builder {
        private String customBasePath;
        private String additionalData;
        private Boolean isTransient;
        private String clientId;
        private String oneTimeLinkCode;

        RequestTokenByOneTimeLinkCodeResponseV3Builder() {
        }

        public RequestTokenByOneTimeLinkCodeResponseV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public RequestTokenByOneTimeLinkCodeResponseV3Builder additionalData(String additionalData) {
            this.additionalData = additionalData;
            return this;
        }

        public RequestTokenByOneTimeLinkCodeResponseV3Builder isTransient(Boolean isTransient) {
            this.isTransient = isTransient;
            return this;
        }

        public RequestTokenByOneTimeLinkCodeResponseV3Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public RequestTokenByOneTimeLinkCodeResponseV3Builder oneTimeLinkCode(String oneTimeLinkCode) {
            this.oneTimeLinkCode = oneTimeLinkCode;
            return this;
        }

        public RequestTokenByOneTimeLinkCodeResponseV3 build() {
            return new RequestTokenByOneTimeLinkCodeResponseV3(this.customBasePath, this.additionalData, this.isTransient, this.clientId, this.oneTimeLinkCode);
        }

        public String toString() {
            return "RequestTokenByOneTimeLinkCodeResponseV3.RequestTokenByOneTimeLinkCodeResponseV3Builder(customBasePath=" + this.customBasePath + ", additionalData=" + this.additionalData + ", isTransient=" + this.isTransient + ", clientId=" + this.clientId + ", oneTimeLinkCode=" + this.oneTimeLinkCode + ")";
        }
    }
}

