/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PlatformAuthenticationV3
extends Operation {
    private String path = "/iam/v3/platforms/{platformId}/authenticate";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("*/*");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = "PLACEHOLDER";
    private String platformId;
    private String code;
    private String error;
    private String openidAssocHandle;
    private String openidClaimedId;
    private String openidIdentity;
    private String openidMode;
    private String openidNs;
    private String openidOpEndpoint;
    private String openidResponseNonce;
    private String openidReturnTo;
    private String openidSig;
    private String openidSigned;
    private String state;

    @Deprecated
    public PlatformAuthenticationV3(String customBasePath, String platformId, String code, String error, String openidAssocHandle, String openidClaimedId, String openidIdentity, String openidMode, String openidNs, String openidOpEndpoint, String openidResponseNonce, String openidReturnTo, String openidSig, String openidSigned, String state) {
        this.platformId = platformId;
        this.code = code;
        this.error = error;
        this.openidAssocHandle = openidAssocHandle;
        this.openidClaimedId = openidClaimedId;
        this.openidIdentity = openidIdentity;
        this.openidMode = openidMode;
        this.openidNs = openidNs;
        this.openidOpEndpoint = openidOpEndpoint;
        this.openidResponseNonce = openidResponseNonce;
        this.openidReturnTo = openidReturnTo;
        this.openidSig = openidSig;
        this.openidSigned = openidSigned;
        this.state = state;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.platformId != null) {
            pathParams.put("platformId", this.platformId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("code", this.code == null ? null : Arrays.asList(this.code));
        queryParams.put("error", this.error == null ? null : Arrays.asList(this.error));
        queryParams.put("openid.assoc_handle", this.openidAssocHandle == null ? null : Arrays.asList(this.openidAssocHandle));
        queryParams.put("openid.claimed_id", this.openidClaimedId == null ? null : Arrays.asList(this.openidClaimedId));
        queryParams.put("openid.identity", this.openidIdentity == null ? null : Arrays.asList(this.openidIdentity));
        queryParams.put("openid.mode", this.openidMode == null ? null : Arrays.asList(this.openidMode));
        queryParams.put("openid.ns", this.openidNs == null ? null : Arrays.asList(this.openidNs));
        queryParams.put("openid.op_endpoint", this.openidOpEndpoint == null ? null : Arrays.asList(this.openidOpEndpoint));
        queryParams.put("openid.response_nonce", this.openidResponseNonce == null ? null : Arrays.asList(this.openidResponseNonce));
        queryParams.put("openid.return_to", this.openidReturnTo == null ? null : Arrays.asList(this.openidReturnTo));
        queryParams.put("openid.sig", this.openidSig == null ? null : Arrays.asList(this.openidSig));
        queryParams.put("openid.signed", this.openidSigned == null ? null : Arrays.asList(this.openidSigned));
        queryParams.put("state", this.state == null ? null : Arrays.asList(this.state));
        return queryParams;
    }

    public boolean isValid() {
        if (this.platformId == null) {
            return false;
        }
        return this.state != null;
    }

    public String parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        String json = Helper.convertInputStreamToString((InputStream)payload);
        if (code != 302) {
            throw new HttpResponseException(code, json);
        }
        return json;
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("code", "None");
        result.put("error", "None");
        result.put("openid.assoc_handle", "None");
        result.put("openid.claimed_id", "None");
        result.put("openid.identity", "None");
        result.put("openid.mode", "None");
        result.put("openid.ns", "None");
        result.put("openid.op_endpoint", "None");
        result.put("openid.response_nonce", "None");
        result.put("openid.return_to", "None");
        result.put("openid.sig", "None");
        result.put("openid.signed", "None");
        result.put("state", "None");
        return result;
    }

    public static PlatformAuthenticationV3Builder builder() {
        return new PlatformAuthenticationV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public String getCode() {
        return this.code;
    }

    public String getError() {
        return this.error;
    }

    public String getOpenidAssocHandle() {
        return this.openidAssocHandle;
    }

    public String getOpenidClaimedId() {
        return this.openidClaimedId;
    }

    public String getOpenidIdentity() {
        return this.openidIdentity;
    }

    public String getOpenidMode() {
        return this.openidMode;
    }

    public String getOpenidNs() {
        return this.openidNs;
    }

    public String getOpenidOpEndpoint() {
        return this.openidOpEndpoint;
    }

    public String getOpenidResponseNonce() {
        return this.openidResponseNonce;
    }

    public String getOpenidReturnTo() {
        return this.openidReturnTo;
    }

    public String getOpenidSig() {
        return this.openidSig;
    }

    public String getOpenidSigned() {
        return this.openidSigned;
    }

    public String getState() {
        return this.state;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setOpenidAssocHandle(String openidAssocHandle) {
        this.openidAssocHandle = openidAssocHandle;
    }

    public void setOpenidClaimedId(String openidClaimedId) {
        this.openidClaimedId = openidClaimedId;
    }

    public void setOpenidIdentity(String openidIdentity) {
        this.openidIdentity = openidIdentity;
    }

    public void setOpenidMode(String openidMode) {
        this.openidMode = openidMode;
    }

    public void setOpenidNs(String openidNs) {
        this.openidNs = openidNs;
    }

    public void setOpenidOpEndpoint(String openidOpEndpoint) {
        this.openidOpEndpoint = openidOpEndpoint;
    }

    public void setOpenidResponseNonce(String openidResponseNonce) {
        this.openidResponseNonce = openidResponseNonce;
    }

    public void setOpenidReturnTo(String openidReturnTo) {
        this.openidReturnTo = openidReturnTo;
    }

    public void setOpenidSig(String openidSig) {
        this.openidSig = openidSig;
    }

    public void setOpenidSigned(String openidSigned) {
        this.openidSigned = openidSigned;
    }

    public void setState(String state) {
        this.state = state;
    }

    public static class PlatformAuthenticationV3Builder {
        private String customBasePath;
        private String platformId;
        private String code;
        private String error;
        private String openidAssocHandle;
        private String openidClaimedId;
        private String openidIdentity;
        private String openidMode;
        private String openidNs;
        private String openidOpEndpoint;
        private String openidResponseNonce;
        private String openidReturnTo;
        private String openidSig;
        private String openidSigned;
        private String state;

        PlatformAuthenticationV3Builder() {
        }

        public PlatformAuthenticationV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PlatformAuthenticationV3Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public PlatformAuthenticationV3Builder code(String code) {
            this.code = code;
            return this;
        }

        public PlatformAuthenticationV3Builder error(String error) {
            this.error = error;
            return this;
        }

        public PlatformAuthenticationV3Builder openidAssocHandle(String openidAssocHandle) {
            this.openidAssocHandle = openidAssocHandle;
            return this;
        }

        public PlatformAuthenticationV3Builder openidClaimedId(String openidClaimedId) {
            this.openidClaimedId = openidClaimedId;
            return this;
        }

        public PlatformAuthenticationV3Builder openidIdentity(String openidIdentity) {
            this.openidIdentity = openidIdentity;
            return this;
        }

        public PlatformAuthenticationV3Builder openidMode(String openidMode) {
            this.openidMode = openidMode;
            return this;
        }

        public PlatformAuthenticationV3Builder openidNs(String openidNs) {
            this.openidNs = openidNs;
            return this;
        }

        public PlatformAuthenticationV3Builder openidOpEndpoint(String openidOpEndpoint) {
            this.openidOpEndpoint = openidOpEndpoint;
            return this;
        }

        public PlatformAuthenticationV3Builder openidResponseNonce(String openidResponseNonce) {
            this.openidResponseNonce = openidResponseNonce;
            return this;
        }

        public PlatformAuthenticationV3Builder openidReturnTo(String openidReturnTo) {
            this.openidReturnTo = openidReturnTo;
            return this;
        }

        public PlatformAuthenticationV3Builder openidSig(String openidSig) {
            this.openidSig = openidSig;
            return this;
        }

        public PlatformAuthenticationV3Builder openidSigned(String openidSigned) {
            this.openidSigned = openidSigned;
            return this;
        }

        public PlatformAuthenticationV3Builder state(String state) {
            this.state = state;
            return this;
        }

        public PlatformAuthenticationV3 build() {
            return new PlatformAuthenticationV3(this.customBasePath, this.platformId, this.code, this.error, this.openidAssocHandle, this.openidClaimedId, this.openidIdentity, this.openidMode, this.openidNs, this.openidOpEndpoint, this.openidResponseNonce, this.openidReturnTo, this.openidSig, this.openidSigned, this.state);
        }

        public String toString() {
            return "PlatformAuthenticationV3.PlatformAuthenticationV3Builder(customBasePath=" + this.customBasePath + ", platformId=" + this.platformId + ", code=" + this.code + ", error=" + this.error + ", openidAssocHandle=" + this.openidAssocHandle + ", openidClaimedId=" + this.openidClaimedId + ", openidIdentity=" + this.openidIdentity + ", openidMode=" + this.openidMode + ", openidNs=" + this.openidNs + ", openidOpEndpoint=" + this.openidOpEndpoint + ", openidResponseNonce=" + this.openidResponseNonce + ", openidReturnTo=" + this.openidReturnTo + ", openidSig=" + this.openidSig + ", openidSigned=" + this.openidSigned + ", state=" + this.state + ")";
        }
    }
}

