/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0_extension;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenResponseV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AuthenticationWithPlatformLinkV3
extends Operation {
    private String path = "/iam/v3/authenticateWithLink";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private Boolean extendExp;
    private String clientId;
    private String linkingToken;
    private String password;
    private String username;

    @Deprecated
    public AuthenticationWithPlatformLinkV3(String customBasePath, Boolean extendExp, String clientId, String linkingToken, String password, String username) {
        this.extendExp = extendExp;
        this.clientId = clientId;
        this.linkingToken = linkingToken;
        this.password = password;
        this.username = username;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.extendExp != null) {
            formDataParams.put("extend_exp", this.extendExp == null ? null : String.valueOf(this.extendExp));
        }
        if (this.clientId != null) {
            formDataParams.put("client_id", this.clientId);
        }
        if (this.linkingToken != null) {
            formDataParams.put("linkingToken", this.linkingToken);
        }
        if (this.password != null) {
            formDataParams.put("password", this.password);
        }
        if (this.username != null) {
            formDataParams.put("username", this.username);
        }
        return formDataParams;
    }

    public boolean isValid() {
        if (this.clientId == null) {
            return false;
        }
        if (this.linkingToken == null) {
            return false;
        }
        if (this.password == null) {
            return false;
        }
        return this.username != null;
    }

    public OauthmodelTokenResponseV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OauthmodelTokenResponseV3().createFromJson(json);
    }

    public static AuthenticationWithPlatformLinkV3Builder builder() {
        return new AuthenticationWithPlatformLinkV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public Boolean getExtendExp() {
        return this.extendExp;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getLinkingToken() {
        return this.linkingToken;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setExtendExp(Boolean extendExp) {
        this.extendExp = extendExp;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setLinkingToken(String linkingToken) {
        this.linkingToken = linkingToken;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public static class AuthenticationWithPlatformLinkV3Builder {
        private String customBasePath;
        private Boolean extendExp;
        private String clientId;
        private String linkingToken;
        private String password;
        private String username;

        AuthenticationWithPlatformLinkV3Builder() {
        }

        public AuthenticationWithPlatformLinkV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AuthenticationWithPlatformLinkV3Builder extendExp(Boolean extendExp) {
            this.extendExp = extendExp;
            return this;
        }

        public AuthenticationWithPlatformLinkV3Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public AuthenticationWithPlatformLinkV3Builder linkingToken(String linkingToken) {
            this.linkingToken = linkingToken;
            return this;
        }

        public AuthenticationWithPlatformLinkV3Builder password(String password) {
            this.password = password;
            return this;
        }

        public AuthenticationWithPlatformLinkV3Builder username(String username) {
            this.username = username;
            return this;
        }

        public AuthenticationWithPlatformLinkV3 build() {
            return new AuthenticationWithPlatformLinkV3(this.customBasePath, this.extendExp, this.clientId, this.linkingToken, this.password, this.username);
        }

        public String toString() {
            return "AuthenticationWithPlatformLinkV3.AuthenticationWithPlatformLinkV3Builder(customBasePath=" + this.customBasePath + ", extendExp=" + this.extendExp + ", clientId=" + this.clientId + ", linkingToken=" + this.linkingToken + ", password=" + this.password + ", username=" + this.username + ")";
        }
    }
}

