/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenIntrospectResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class TokenIntrospectionV3
extends Operation {
    private String path = "/iam/v3/oauth/introspect";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String token;

    @Deprecated
    public TokenIntrospectionV3(String customBasePath, String token) {
        this.token = token;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
        this.securities.add("Basic");
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.token != null) {
            formDataParams.put("token", this.token);
        }
        return formDataParams;
    }

    public boolean isValid() {
        return this.token != null;
    }

    public OauthmodelTokenIntrospectResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OauthmodelTokenIntrospectResponse().createFromJson(json);
    }

    public static TokenIntrospectionV3Builder builder() {
        return new TokenIntrospectionV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getToken() {
        return this.token;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public static class TokenIntrospectionV3Builder {
        private String customBasePath;
        private String token;

        TokenIntrospectionV3Builder() {
        }

        public TokenIntrospectionV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public TokenIntrospectionV3Builder token(String token) {
            this.token = token;
            return this;
        }

        public TokenIntrospectionV3 build() {
            return new TokenIntrospectionV3(this.customBasePath, this.token);
        }

        public String toString() {
            return "TokenIntrospectionV3.TokenIntrospectionV3Builder(customBasePath=" + this.customBasePath + ", token=" + this.token + ")";
        }
    }
}

