/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenWithDeviceCookieResponseV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class TokenGrantV3
extends Operation {
    private String path = "/iam/v3/oauth/token";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String additionalData;
    private String clientId;
    private String clientSecret;
    private String code;
    private String codeVerifier;
    private String extendNamespace;
    private Boolean extendExp;
    private String password;
    private String redirectUri;
    private String refreshToken;
    private String username;
    private String grantType;

    @Deprecated
    public TokenGrantV3(String customBasePath, String additionalData, String clientId, String clientSecret, String code, String codeVerifier, String extendNamespace, Boolean extendExp, String password, String redirectUri, String refreshToken, String username, String grantType) {
        this.additionalData = additionalData;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.code = code;
        this.codeVerifier = codeVerifier;
        this.extendNamespace = extendNamespace;
        this.extendExp = extendExp;
        this.password = password;
        this.redirectUri = redirectUri;
        this.refreshToken = refreshToken;
        this.username = username;
        this.grantType = grantType;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Basic");
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.additionalData != null) {
            formDataParams.put("additionalData", this.additionalData);
        }
        if (this.clientId != null) {
            formDataParams.put("client_id", this.clientId);
        }
        if (this.clientSecret != null) {
            formDataParams.put("client_secret", this.clientSecret);
        }
        if (this.code != null) {
            formDataParams.put("code", this.code);
        }
        if (this.codeVerifier != null) {
            formDataParams.put("code_verifier", this.codeVerifier);
        }
        if (this.extendNamespace != null) {
            formDataParams.put("extendNamespace", this.extendNamespace);
        }
        if (this.extendExp != null) {
            formDataParams.put("extend_exp", this.extendExp == null ? null : String.valueOf(this.extendExp));
        }
        if (this.password != null) {
            formDataParams.put("password", this.password);
        }
        if (this.redirectUri != null) {
            formDataParams.put("redirect_uri", this.redirectUri);
        }
        if (this.refreshToken != null) {
            formDataParams.put("refresh_token", this.refreshToken);
        }
        if (this.username != null) {
            formDataParams.put("username", this.username);
        }
        if (this.grantType != null) {
            formDataParams.put("grant_type", this.grantType);
        }
        return formDataParams;
    }

    public boolean isValid() {
        return this.grantType != null;
    }

    public OauthmodelTokenWithDeviceCookieResponseV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OauthmodelTokenWithDeviceCookieResponseV3().createFromJson(json);
    }

    public static TokenGrantV3Builder builder() {
        return new TokenGrantV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getCode() {
        return this.code;
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public String getExtendNamespace() {
        return this.extendNamespace;
    }

    public Boolean getExtendExp() {
        return this.extendExp;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getUsername() {
        return this.username;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setCodeVerifier(String codeVerifier) {
        this.codeVerifier = codeVerifier;
    }

    public void setExtendNamespace(String extendNamespace) {
        this.extendNamespace = extendNamespace;
    }

    public void setExtendExp(Boolean extendExp) {
        this.extendExp = extendExp;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public static class TokenGrantV3Builder {
        private String customBasePath;
        private String additionalData;
        private String clientId;
        private String clientSecret;
        private String code;
        private String codeVerifier;
        private String extendNamespace;
        private Boolean extendExp;
        private String password;
        private String redirectUri;
        private String refreshToken;
        private String username;
        private String grantType;

        public TokenGrantV3Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public TokenGrantV3Builder grantTypeFromEnum(GrantType grantType) {
            this.grantType = grantType.toString();
            return this;
        }

        TokenGrantV3Builder() {
        }

        public TokenGrantV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public TokenGrantV3Builder additionalData(String additionalData) {
            this.additionalData = additionalData;
            return this;
        }

        public TokenGrantV3Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public TokenGrantV3Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public TokenGrantV3Builder code(String code) {
            this.code = code;
            return this;
        }

        public TokenGrantV3Builder codeVerifier(String codeVerifier) {
            this.codeVerifier = codeVerifier;
            return this;
        }

        public TokenGrantV3Builder extendNamespace(String extendNamespace) {
            this.extendNamespace = extendNamespace;
            return this;
        }

        public TokenGrantV3Builder extendExp(Boolean extendExp) {
            this.extendExp = extendExp;
            return this;
        }

        public TokenGrantV3Builder password(String password) {
            this.password = password;
            return this;
        }

        public TokenGrantV3Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public TokenGrantV3Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public TokenGrantV3Builder username(String username) {
            this.username = username;
            return this;
        }

        public TokenGrantV3 build() {
            return new TokenGrantV3(this.customBasePath, this.additionalData, this.clientId, this.clientSecret, this.code, this.codeVerifier, this.extendNamespace, this.extendExp, this.password, this.redirectUri, this.refreshToken, this.username, this.grantType);
        }

        public String toString() {
            return "TokenGrantV3.TokenGrantV3Builder(customBasePath=" + this.customBasePath + ", additionalData=" + this.additionalData + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", code=" + this.code + ", codeVerifier=" + this.codeVerifier + ", extendNamespace=" + this.extendNamespace + ", extendExp=" + this.extendExp + ", password=" + this.password + ", redirectUri=" + this.redirectUri + ", refreshToken=" + this.refreshToken + ", username=" + this.username + ", grantType=" + this.grantType + ")";
        }
    }

    public static enum GrantType {
        AuthorizationCode("authorization_code"),
        ClientCredentials("client_credentials"),
        Password("password"),
        RefreshToken("refresh_token"),
        UrnietfparamsoauthgrantTypeextendClientCredentials("urn:ietf:params:oauth:grant-type:extend_client_credentials");

        private String value;

        private GrantType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

