/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenResponseV3;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class SimultaneousLoginV3
extends Operation {
    private String path = "/iam/v3/oauth/simultaneousLogin";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String simultaneousPlatform;
    private String simultaneousTicket;
    private String nativePlatform;
    private String nativePlatformTicket;

    @Deprecated
    public SimultaneousLoginV3(String customBasePath, String simultaneousPlatform, String simultaneousTicket, String nativePlatform, String nativePlatformTicket) {
        this.simultaneousPlatform = simultaneousPlatform;
        this.simultaneousTicket = simultaneousTicket;
        this.nativePlatform = nativePlatform;
        this.nativePlatformTicket = nativePlatformTicket;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.simultaneousPlatform != null) {
            formDataParams.put("simultaneousPlatform", this.simultaneousPlatform);
        }
        if (this.simultaneousTicket != null) {
            formDataParams.put("simultaneousTicket", this.simultaneousTicket);
        }
        if (this.nativePlatform != null) {
            formDataParams.put("nativePlatform", this.nativePlatform);
        }
        if (this.nativePlatformTicket != null) {
            formDataParams.put("nativePlatformTicket", this.nativePlatformTicket);
        }
        return formDataParams;
    }

    public boolean isValid() {
        if (this.nativePlatform == null) {
            return false;
        }
        return this.nativePlatformTicket != null;
    }

    public OauthmodelTokenResponseV3 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OauthmodelTokenResponseV3().createFromJson(json);
    }

    public static SimultaneousLoginV3Builder builder() {
        return new SimultaneousLoginV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getSimultaneousPlatform() {
        return this.simultaneousPlatform;
    }

    public String getSimultaneousTicket() {
        return this.simultaneousTicket;
    }

    public String getNativePlatform() {
        return this.nativePlatform;
    }

    public String getNativePlatformTicket() {
        return this.nativePlatformTicket;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setSimultaneousPlatform(String simultaneousPlatform) {
        this.simultaneousPlatform = simultaneousPlatform;
    }

    public void setSimultaneousTicket(String simultaneousTicket) {
        this.simultaneousTicket = simultaneousTicket;
    }

    public void setNativePlatform(String nativePlatform) {
        this.nativePlatform = nativePlatform;
    }

    public void setNativePlatformTicket(String nativePlatformTicket) {
        this.nativePlatformTicket = nativePlatformTicket;
    }

    public static class SimultaneousLoginV3Builder {
        private String customBasePath;
        private String simultaneousPlatform;
        private String simultaneousTicket;
        private String nativePlatformTicket;
        private String nativePlatform;

        public SimultaneousLoginV3Builder nativePlatform(String nativePlatform) {
            this.nativePlatform = nativePlatform;
            return this;
        }

        public SimultaneousLoginV3Builder nativePlatformFromEnum(NativePlatform nativePlatform) {
            this.nativePlatform = nativePlatform.toString();
            return this;
        }

        SimultaneousLoginV3Builder() {
        }

        public SimultaneousLoginV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public SimultaneousLoginV3Builder simultaneousPlatform(String simultaneousPlatform) {
            this.simultaneousPlatform = simultaneousPlatform;
            return this;
        }

        public SimultaneousLoginV3Builder simultaneousTicket(String simultaneousTicket) {
            this.simultaneousTicket = simultaneousTicket;
            return this;
        }

        public SimultaneousLoginV3Builder nativePlatformTicket(String nativePlatformTicket) {
            this.nativePlatformTicket = nativePlatformTicket;
            return this;
        }

        public SimultaneousLoginV3 build() {
            return new SimultaneousLoginV3(this.customBasePath, this.simultaneousPlatform, this.simultaneousTicket, this.nativePlatform, this.nativePlatformTicket);
        }

        public String toString() {
            return "SimultaneousLoginV3.SimultaneousLoginV3Builder(customBasePath=" + this.customBasePath + ", simultaneousPlatform=" + this.simultaneousPlatform + ", simultaneousTicket=" + this.simultaneousTicket + ", nativePlatform=" + this.nativePlatform + ", nativePlatformTicket=" + this.nativePlatformTicket + ")";
        }
    }

    public static enum NativePlatform {
        Epicgames("epicgames"),
        Steam("steam");

        private String value;

        private NativePlatform(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

