/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class SendMFAAuthenticationCode
extends Operation {
    private String path = "/iam/v3/oauth/mfa/code";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String clientId;
    private String factor;
    private String mfaToken;

    @Deprecated
    public SendMFAAuthenticationCode(String customBasePath, String clientId, String factor, String mfaToken) {
        this.clientId = clientId;
        this.factor = factor;
        this.mfaToken = mfaToken;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.clientId != null) {
            formDataParams.put("clientId", this.clientId);
        }
        if (this.factor != null) {
            formDataParams.put("factor", this.factor);
        }
        if (this.mfaToken != null) {
            formDataParams.put("mfaToken", this.mfaToken);
        }
        return formDataParams;
    }

    public boolean isValid() {
        if (this.clientId == null) {
            return false;
        }
        if (this.factor == null) {
            return false;
        }
        return this.mfaToken != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    public static SendMFAAuthenticationCodeBuilder builder() {
        return new SendMFAAuthenticationCodeBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getFactor() {
        return this.factor;
    }

    public String getMfaToken() {
        return this.mfaToken;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setFactor(String factor) {
        this.factor = factor;
    }

    public void setMfaToken(String mfaToken) {
        this.mfaToken = mfaToken;
    }

    public static class SendMFAAuthenticationCodeBuilder {
        private String customBasePath;
        private String clientId;
        private String factor;
        private String mfaToken;

        SendMFAAuthenticationCodeBuilder() {
        }

        public SendMFAAuthenticationCodeBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public SendMFAAuthenticationCodeBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public SendMFAAuthenticationCodeBuilder factor(String factor) {
            this.factor = factor;
            return this;
        }

        public SendMFAAuthenticationCodeBuilder mfaToken(String mfaToken) {
            this.mfaToken = mfaToken;
            return this;
        }

        public SendMFAAuthenticationCode build() {
            return new SendMFAAuthenticationCode(this.customBasePath, this.clientId, this.factor, this.mfaToken);
        }

        public String toString() {
            return "SendMFAAuthenticationCode.SendMFAAuthenticationCodeBuilder(customBasePath=" + this.customBasePath + ", clientId=" + this.clientId + ", factor=" + this.factor + ", mfaToken=" + this.mfaToken + ")";
        }
    }
}

