/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RevokeUserV3
extends Operation {
    private String path = "/iam/v3/oauth/admin/namespaces/{namespace}/users/{userId}/revoke";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("*/*");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private Boolean includeGameNamespace;

    @Deprecated
    public RevokeUserV3(String customBasePath, String namespace, String userId, Boolean includeGameNamespace) {
        this.namespace = namespace;
        this.userId = userId;
        this.includeGameNamespace = includeGameNamespace;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("includeGameNamespace", this.includeGameNamespace == null ? null : Arrays.asList(String.valueOf(this.includeGameNamespace)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("includeGameNamespace", "None");
        return result;
    }

    public static RevokeUserV3Builder builder() {
        return new RevokeUserV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public Boolean getIncludeGameNamespace() {
        return this.includeGameNamespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setIncludeGameNamespace(Boolean includeGameNamespace) {
        this.includeGameNamespace = includeGameNamespace;
    }

    public static class RevokeUserV3Builder {
        private String customBasePath;
        private String namespace;
        private String userId;
        private Boolean includeGameNamespace;

        RevokeUserV3Builder() {
        }

        public RevokeUserV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public RevokeUserV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RevokeUserV3Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public RevokeUserV3Builder includeGameNamespace(Boolean includeGameNamespace) {
            this.includeGameNamespace = includeGameNamespace;
            return this;
        }

        public RevokeUserV3 build() {
            return new RevokeUserV3(this.customBasePath, this.namespace, this.userId, this.includeGameNamespace);
        }

        public String toString() {
            return "RevokeUserV3.RevokeUserV3Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", userId=" + this.userId + ", includeGameNamespace=" + this.includeGameNamespace + ")";
        }
    }
}

