/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PlatformTokenGrantV3
extends Operation {
    private String path = "/iam/v3/oauth/platforms/{platformId}/token";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String platformId;
    private String additionalData;
    private String clientId;
    private Boolean createHeadless;
    private String deviceId;
    private String macAddress;
    private String platformToken;
    private Float serviceLabel;
    private Boolean skipSetCookie;

    @Deprecated
    public PlatformTokenGrantV3(String customBasePath, String platformId, String additionalData, String clientId, Boolean createHeadless, String deviceId, String macAddress, String platformToken, Float serviceLabel, Boolean skipSetCookie) {
        this.platformId = platformId;
        this.additionalData = additionalData;
        this.clientId = clientId;
        this.createHeadless = createHeadless;
        this.deviceId = deviceId;
        this.macAddress = macAddress;
        this.platformToken = platformToken;
        this.serviceLabel = serviceLabel;
        this.skipSetCookie = skipSetCookie;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Basic");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.platformId != null) {
            pathParams.put("platformId", this.platformId);
        }
        return pathParams;
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.additionalData != null) {
            formDataParams.put("additionalData", this.additionalData);
        }
        if (this.clientId != null) {
            formDataParams.put("client_id", this.clientId);
        }
        if (this.createHeadless != null) {
            formDataParams.put("createHeadless", this.createHeadless == null ? null : String.valueOf(this.createHeadless));
        }
        if (this.deviceId != null) {
            formDataParams.put("device_id", this.deviceId);
        }
        if (this.macAddress != null) {
            formDataParams.put("macAddress", this.macAddress);
        }
        if (this.platformToken != null) {
            formDataParams.put("platform_token", this.platformToken);
        }
        if (this.serviceLabel != null) {
            formDataParams.put("serviceLabel", this.serviceLabel == null ? null : String.valueOf(this.serviceLabel));
        }
        if (this.skipSetCookie != null) {
            formDataParams.put("skipSetCookie", this.skipSetCookie == null ? null : String.valueOf(this.skipSetCookie));
        }
        return formDataParams;
    }

    public boolean isValid() {
        return this.platformId != null;
    }

    public OauthmodelTokenResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OauthmodelTokenResponse().createFromJson(json);
    }

    public static PlatformTokenGrantV3Builder builder() {
        return new PlatformTokenGrantV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Boolean getCreateHeadless() {
        return this.createHeadless;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getPlatformToken() {
        return this.platformToken;
    }

    public Float getServiceLabel() {
        return this.serviceLabel;
    }

    public Boolean getSkipSetCookie() {
        return this.skipSetCookie;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setCreateHeadless(Boolean createHeadless) {
        this.createHeadless = createHeadless;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public void setPlatformToken(String platformToken) {
        this.platformToken = platformToken;
    }

    public void setServiceLabel(Float serviceLabel) {
        this.serviceLabel = serviceLabel;
    }

    public void setSkipSetCookie(Boolean skipSetCookie) {
        this.skipSetCookie = skipSetCookie;
    }

    public static class PlatformTokenGrantV3Builder {
        private String customBasePath;
        private String platformId;
        private String additionalData;
        private String clientId;
        private Boolean createHeadless;
        private String deviceId;
        private String macAddress;
        private String platformToken;
        private Float serviceLabel;
        private Boolean skipSetCookie;

        PlatformTokenGrantV3Builder() {
        }

        public PlatformTokenGrantV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PlatformTokenGrantV3Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public PlatformTokenGrantV3Builder additionalData(String additionalData) {
            this.additionalData = additionalData;
            return this;
        }

        public PlatformTokenGrantV3Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public PlatformTokenGrantV3Builder createHeadless(Boolean createHeadless) {
            this.createHeadless = createHeadless;
            return this;
        }

        public PlatformTokenGrantV3Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public PlatformTokenGrantV3Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public PlatformTokenGrantV3Builder platformToken(String platformToken) {
            this.platformToken = platformToken;
            return this;
        }

        public PlatformTokenGrantV3Builder serviceLabel(Float serviceLabel) {
            this.serviceLabel = serviceLabel;
            return this;
        }

        public PlatformTokenGrantV3Builder skipSetCookie(Boolean skipSetCookie) {
            this.skipSetCookie = skipSetCookie;
            return this;
        }

        public PlatformTokenGrantV3 build() {
            return new PlatformTokenGrantV3(this.customBasePath, this.platformId, this.additionalData, this.clientId, this.createHeadless, this.deviceId, this.macAddress, this.platformToken, this.serviceLabel, this.skipSetCookie);
        }

        public String toString() {
            return "PlatformTokenGrantV3.PlatformTokenGrantV3Builder(customBasePath=" + this.customBasePath + ", platformId=" + this.platformId + ", additionalData=" + this.additionalData + ", clientId=" + this.clientId + ", createHeadless=" + this.createHeadless + ", deviceId=" + this.deviceId + ", macAddress=" + this.macAddress + ", platformToken=" + this.platformToken + ", serviceLabel=" + this.serviceLabel + ", skipSetCookie=" + this.skipSetCookie + ")";
        }
    }
}

