/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AuthorizeV3
extends Operation {
    private String path = "/iam/v3/oauth/authorize";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = "request_id";
    private String codeChallenge;
    private String codeChallengeMethod;
    private Boolean createHeadless;
    private String oneTimeLinkCode;
    private String redirectUri;
    private String scope;
    private String state;
    private String targetAuthPage;
    private Boolean useRedirectUriAsLoginUrlWhenLocked;
    private String clientId;
    private String responseType;

    @Deprecated
    public AuthorizeV3(String customBasePath, String codeChallenge, String codeChallengeMethod, Boolean createHeadless, String oneTimeLinkCode, String redirectUri, String scope, String state, String targetAuthPage, Boolean useRedirectUriAsLoginUrlWhenLocked, String clientId, String responseType) {
        this.codeChallenge = codeChallenge;
        this.codeChallengeMethod = codeChallengeMethod;
        this.createHeadless = createHeadless;
        this.oneTimeLinkCode = oneTimeLinkCode;
        this.redirectUri = redirectUri;
        this.scope = scope;
        this.state = state;
        this.targetAuthPage = targetAuthPage;
        this.useRedirectUriAsLoginUrlWhenLocked = useRedirectUriAsLoginUrlWhenLocked;
        this.clientId = clientId;
        this.responseType = responseType;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Basic");
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("code_challenge", this.codeChallenge == null ? null : Arrays.asList(this.codeChallenge));
        queryParams.put("code_challenge_method", this.codeChallengeMethod == null ? null : Arrays.asList(this.codeChallengeMethod));
        queryParams.put("createHeadless", this.createHeadless == null ? null : Arrays.asList(String.valueOf(this.createHeadless)));
        queryParams.put("oneTimeLinkCode", this.oneTimeLinkCode == null ? null : Arrays.asList(this.oneTimeLinkCode));
        queryParams.put("redirect_uri", this.redirectUri == null ? null : Arrays.asList(this.redirectUri));
        queryParams.put("scope", this.scope == null ? null : Arrays.asList(this.scope));
        queryParams.put("state", this.state == null ? null : Arrays.asList(this.state));
        queryParams.put("target_auth_page", this.targetAuthPage == null ? null : Arrays.asList(this.targetAuthPage));
        queryParams.put("useRedirectUriAsLoginUrlWhenLocked", this.useRedirectUriAsLoginUrlWhenLocked == null ? null : Arrays.asList(String.valueOf(this.useRedirectUriAsLoginUrlWhenLocked)));
        queryParams.put("client_id", this.clientId == null ? null : Arrays.asList(this.clientId));
        queryParams.put("response_type", this.responseType == null ? null : Arrays.asList(this.responseType));
        return queryParams;
    }

    public boolean isValid() {
        if (this.clientId == null) {
            return false;
        }
        return this.responseType != null;
    }

    public String parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        String json = Helper.convertInputStreamToString((InputStream)payload);
        if (code != 302) {
            throw new HttpResponseException(code, json);
        }
        return json;
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("code_challenge", "None");
        result.put("code_challenge_method", "None");
        result.put("createHeadless", "None");
        result.put("oneTimeLinkCode", "None");
        result.put("redirect_uri", "None");
        result.put("scope", "None");
        result.put("state", "None");
        result.put("target_auth_page", "None");
        result.put("useRedirectUriAsLoginUrlWhenLocked", "None");
        result.put("client_id", "None");
        result.put("response_type", "None");
        return result;
    }

    public static AuthorizeV3Builder builder() {
        return new AuthorizeV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public Boolean getCreateHeadless() {
        return this.createHeadless;
    }

    public String getOneTimeLinkCode() {
        return this.oneTimeLinkCode;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getScope() {
        return this.scope;
    }

    public String getState() {
        return this.state;
    }

    public String getTargetAuthPage() {
        return this.targetAuthPage;
    }

    public Boolean getUseRedirectUriAsLoginUrlWhenLocked() {
        return this.useRedirectUriAsLoginUrlWhenLocked;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public void setCreateHeadless(Boolean createHeadless) {
        this.createHeadless = createHeadless;
    }

    public void setOneTimeLinkCode(String oneTimeLinkCode) {
        this.oneTimeLinkCode = oneTimeLinkCode;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setTargetAuthPage(String targetAuthPage) {
        this.targetAuthPage = targetAuthPage;
    }

    public void setUseRedirectUriAsLoginUrlWhenLocked(Boolean useRedirectUriAsLoginUrlWhenLocked) {
        this.useRedirectUriAsLoginUrlWhenLocked = useRedirectUriAsLoginUrlWhenLocked;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public static class AuthorizeV3Builder {
        private String customBasePath;
        private String codeChallenge;
        private Boolean createHeadless;
        private String oneTimeLinkCode;
        private String redirectUri;
        private String scope;
        private String state;
        private String targetAuthPage;
        private Boolean useRedirectUriAsLoginUrlWhenLocked;
        private String clientId;
        private String codeChallengeMethod;
        private String responseType;

        public AuthorizeV3Builder codeChallengeMethod(String codeChallengeMethod) {
            this.codeChallengeMethod = codeChallengeMethod;
            return this;
        }

        public AuthorizeV3Builder codeChallengeMethodFromEnum(CodeChallengeMethod codeChallengeMethod) {
            this.codeChallengeMethod = codeChallengeMethod.toString();
            return this;
        }

        public AuthorizeV3Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        public AuthorizeV3Builder responseTypeFromEnum(ResponseType responseType) {
            this.responseType = responseType.toString();
            return this;
        }

        AuthorizeV3Builder() {
        }

        public AuthorizeV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AuthorizeV3Builder codeChallenge(String codeChallenge) {
            this.codeChallenge = codeChallenge;
            return this;
        }

        public AuthorizeV3Builder createHeadless(Boolean createHeadless) {
            this.createHeadless = createHeadless;
            return this;
        }

        public AuthorizeV3Builder oneTimeLinkCode(String oneTimeLinkCode) {
            this.oneTimeLinkCode = oneTimeLinkCode;
            return this;
        }

        public AuthorizeV3Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public AuthorizeV3Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public AuthorizeV3Builder state(String state) {
            this.state = state;
            return this;
        }

        public AuthorizeV3Builder targetAuthPage(String targetAuthPage) {
            this.targetAuthPage = targetAuthPage;
            return this;
        }

        public AuthorizeV3Builder useRedirectUriAsLoginUrlWhenLocked(Boolean useRedirectUriAsLoginUrlWhenLocked) {
            this.useRedirectUriAsLoginUrlWhenLocked = useRedirectUriAsLoginUrlWhenLocked;
            return this;
        }

        public AuthorizeV3Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public AuthorizeV3 build() {
            return new AuthorizeV3(this.customBasePath, this.codeChallenge, this.codeChallengeMethod, this.createHeadless, this.oneTimeLinkCode, this.redirectUri, this.scope, this.state, this.targetAuthPage, this.useRedirectUriAsLoginUrlWhenLocked, this.clientId, this.responseType);
        }

        public String toString() {
            return "AuthorizeV3.AuthorizeV3Builder(customBasePath=" + this.customBasePath + ", codeChallenge=" + this.codeChallenge + ", codeChallengeMethod=" + this.codeChallengeMethod + ", createHeadless=" + this.createHeadless + ", oneTimeLinkCode=" + this.oneTimeLinkCode + ", redirectUri=" + this.redirectUri + ", scope=" + this.scope + ", state=" + this.state + ", targetAuthPage=" + this.targetAuthPage + ", useRedirectUriAsLoginUrlWhenLocked=" + this.useRedirectUriAsLoginUrlWhenLocked + ", clientId=" + this.clientId + ", responseType=" + this.responseType + ")";
        }
    }

    public static enum ResponseType {
        Code("code");

        private String value;

        private ResponseType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum CodeChallengeMethod {
        S256("S256"),
        Plain("plain");

        private String value;

        private CodeChallengeMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

