/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth2_0;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AuthCodeRequestV3
extends Operation {
    private String path = "/iam/v3/oauth/platforms/{platformId}/authorize";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = "code";
    private String platformId;
    private String clientId;
    private String redirectUri;
    private String requestId;

    @Deprecated
    public AuthCodeRequestV3(String customBasePath, String platformId, String clientId, String redirectUri, String requestId) {
        this.platformId = platformId;
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        this.requestId = requestId;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.platformId != null) {
            pathParams.put("platformId", this.platformId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("client_id", this.clientId == null ? null : Arrays.asList(this.clientId));
        queryParams.put("redirect_uri", this.redirectUri == null ? null : Arrays.asList(this.redirectUri));
        queryParams.put("request_id", this.requestId == null ? null : Arrays.asList(this.requestId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.platformId == null) {
            return false;
        }
        return this.requestId != null;
    }

    public String parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        String json = Helper.convertInputStreamToString((InputStream)payload);
        if (code != 302) {
            throw new HttpResponseException(code, json);
        }
        return json;
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("client_id", "None");
        result.put("redirect_uri", "None");
        result.put("request_id", "None");
        return result;
    }

    public static AuthCodeRequestV3Builder builder() {
        return new AuthCodeRequestV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public static class AuthCodeRequestV3Builder {
        private String customBasePath;
        private String platformId;
        private String clientId;
        private String redirectUri;
        private String requestId;

        AuthCodeRequestV3Builder() {
        }

        public AuthCodeRequestV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AuthCodeRequestV3Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public AuthCodeRequestV3Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public AuthCodeRequestV3Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public AuthCodeRequestV3Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public AuthCodeRequestV3 build() {
            return new AuthCodeRequestV3(this.customBasePath, this.platformId, this.clientId, this.redirectUri, this.requestId);
        }

        public String toString() {
            return "AuthCodeRequestV3.AuthCodeRequestV3Builder(customBasePath=" + this.customBasePath + ", platformId=" + this.platformId + ", clientId=" + this.clientId + ", redirectUri=" + this.redirectUri + ", requestId=" + this.requestId + ")";
        }
    }
}

