/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.o_auth;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.OauthmodelTokenResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

@Deprecated
public class TokenGrant
extends Operation {
    private String path = "/iam/oauth/token";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/x-www-form-urlencoded");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String code;
    private Boolean extendExp;
    private String namespace;
    private String password;
    private String redirectUri;
    private String refreshToken;
    private String username;
    private String grantType;

    @Deprecated
    public TokenGrant(String customBasePath, String code, Boolean extendExp, String namespace, String password, String redirectUri, String refreshToken, String username, String grantType) {
        this.code = code;
        this.extendExp = extendExp;
        this.namespace = namespace;
        this.password = password;
        this.redirectUri = redirectUri;
        this.refreshToken = refreshToken;
        this.username = username;
        this.grantType = grantType;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.code != null) {
            formDataParams.put("code", this.code);
        }
        if (this.extendExp != null) {
            formDataParams.put("extend_exp", this.extendExp == null ? null : String.valueOf(this.extendExp));
        }
        if (this.namespace != null) {
            formDataParams.put("namespace", this.namespace);
        }
        if (this.password != null) {
            formDataParams.put("password", this.password);
        }
        if (this.redirectUri != null) {
            formDataParams.put("redirect_uri", this.redirectUri);
        }
        if (this.refreshToken != null) {
            formDataParams.put("refresh_token", this.refreshToken);
        }
        if (this.username != null) {
            formDataParams.put("username", this.username);
        }
        if (this.grantType != null) {
            formDataParams.put("grant_type", this.grantType);
        }
        return formDataParams;
    }

    public boolean isValid() {
        return this.grantType != null;
    }

    public OauthmodelTokenResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OauthmodelTokenResponse().createFromJson(json);
    }

    public static TokenGrantBuilder builder() {
        return new TokenGrantBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCode() {
        return this.code;
    }

    public Boolean getExtendExp() {
        return this.extendExp;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getUsername() {
        return this.username;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setExtendExp(Boolean extendExp) {
        this.extendExp = extendExp;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public static class TokenGrantBuilder {
        private String customBasePath;
        private String code;
        private Boolean extendExp;
        private String namespace;
        private String password;
        private String redirectUri;
        private String refreshToken;
        private String username;
        private String grantType;

        public TokenGrantBuilder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public TokenGrantBuilder grantTypeFromEnum(GrantType grantType) {
            this.grantType = grantType.toString();
            return this;
        }

        TokenGrantBuilder() {
        }

        public TokenGrantBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public TokenGrantBuilder code(String code) {
            this.code = code;
            return this;
        }

        public TokenGrantBuilder extendExp(Boolean extendExp) {
            this.extendExp = extendExp;
            return this;
        }

        public TokenGrantBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public TokenGrantBuilder password(String password) {
            this.password = password;
            return this;
        }

        public TokenGrantBuilder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public TokenGrantBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public TokenGrantBuilder username(String username) {
            this.username = username;
            return this;
        }

        public TokenGrant build() {
            return new TokenGrant(this.customBasePath, this.code, this.extendExp, this.namespace, this.password, this.redirectUri, this.refreshToken, this.username, this.grantType);
        }

        public String toString() {
            return "TokenGrant.TokenGrantBuilder(customBasePath=" + this.customBasePath + ", code=" + this.code + ", extendExp=" + this.extendExp + ", namespace=" + this.namespace + ", password=" + this.password + ", redirectUri=" + this.redirectUri + ", refreshToken=" + this.refreshToken + ", username=" + this.username + ", grantType=" + this.grantType + ")";
        }
    }

    public static enum GrantType {
        AuthorizationCode("authorization_code"),
        ClientCredentials("client_credentials"),
        Password("password"),
        RefreshToken("refresh_token");

        private String value;

        private GrantType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

