/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.input_validations;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelInputValidationsPublicResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetInputValidations
extends Operation {
    private String path = "/iam/v3/public/inputValidations";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private Boolean defaultOnEmpty;
    private String languageCode;

    @Deprecated
    public PublicGetInputValidations(String customBasePath, Boolean defaultOnEmpty, String languageCode) {
        this.defaultOnEmpty = defaultOnEmpty;
        this.languageCode = languageCode;
        this.customBasePath = customBasePath != null ? customBasePath : "";
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("defaultOnEmpty", this.defaultOnEmpty == null ? null : Arrays.asList(String.valueOf(this.defaultOnEmpty)));
        queryParams.put("languageCode", this.languageCode == null ? null : Arrays.asList(this.languageCode));
        return queryParams;
    }

    public boolean isValid() {
        return true;
    }

    public ModelInputValidationsPublicResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelInputValidationsPublicResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("defaultOnEmpty", "None");
        result.put("languageCode", "None");
        return result;
    }

    public static PublicGetInputValidationsBuilder builder() {
        return new PublicGetInputValidationsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public Boolean getDefaultOnEmpty() {
        return this.defaultOnEmpty;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setDefaultOnEmpty(Boolean defaultOnEmpty) {
        this.defaultOnEmpty = defaultOnEmpty;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public static class PublicGetInputValidationsBuilder {
        private String customBasePath;
        private Boolean defaultOnEmpty;
        private String languageCode;

        PublicGetInputValidationsBuilder() {
        }

        public PublicGetInputValidationsBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PublicGetInputValidationsBuilder defaultOnEmpty(Boolean defaultOnEmpty) {
            this.defaultOnEmpty = defaultOnEmpty;
            return this;
        }

        public PublicGetInputValidationsBuilder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public PublicGetInputValidations build() {
            return new PublicGetInputValidations(this.customBasePath, this.defaultOnEmpty, this.languageCode);
        }

        public String toString() {
            return "PublicGetInputValidations.PublicGetInputValidationsBuilder(customBasePath=" + this.customBasePath + ", defaultOnEmpty=" + this.defaultOnEmpty + ", languageCode=" + this.languageCode + ")";
        }
    }
}

