/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.devices_v4;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelDeviceBanResponseV4;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetDeviceBanV4
extends Operation {
    private String path = "/iam/v4/admin/namespaces/{namespace}/devices/bans/{banId}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String banId;
    private String namespace;

    @Deprecated
    public AdminGetDeviceBanV4(String customBasePath, String banId, String namespace) {
        this.banId = banId;
        this.namespace = namespace;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.banId != null) {
            pathParams.put("banId", this.banId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.banId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelDeviceBanResponseV4 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelDeviceBanResponseV4().createFromJson(json);
    }

    public static AdminGetDeviceBanV4Builder builder() {
        return new AdminGetDeviceBanV4Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getBanId() {
        return this.banId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setBanId(String banId) {
        this.banId = banId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class AdminGetDeviceBanV4Builder {
        private String customBasePath;
        private String banId;
        private String namespace;

        AdminGetDeviceBanV4Builder() {
        }

        public AdminGetDeviceBanV4Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminGetDeviceBanV4Builder banId(String banId) {
            this.banId = banId;
            return this;
        }

        public AdminGetDeviceBanV4Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminGetDeviceBanV4 build() {
            return new AdminGetDeviceBanV4(this.customBasePath, this.banId, this.namespace);
        }

        public String toString() {
            return "AdminGetDeviceBanV4.AdminGetDeviceBanV4Builder(customBasePath=" + this.customBasePath + ", banId=" + this.banId + ", namespace=" + this.namespace + ")";
        }
    }
}

