/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.devices_v4;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelDeviceBannedResponseV4;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetBannedDevicesV4
extends Operation {
    private String path = "/iam/v4/admin/namespaces/{namespace}/devices/banned";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String deviceType;
    private String endDate;
    private Integer limit;
    private Integer offset;
    private String startDate;

    @Deprecated
    public AdminGetBannedDevicesV4(String customBasePath, String namespace, String deviceType, String endDate, Integer limit, Integer offset, String startDate) {
        this.namespace = namespace;
        this.deviceType = deviceType;
        this.endDate = endDate;
        this.limit = limit;
        this.offset = offset;
        this.startDate = startDate;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("deviceType", this.deviceType == null ? null : Arrays.asList(this.deviceType));
        queryParams.put("endDate", this.endDate == null ? null : Arrays.asList(this.endDate));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("startDate", this.startDate == null ? null : Arrays.asList(this.startDate));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ModelDeviceBannedResponseV4 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelDeviceBannedResponseV4().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("deviceType", "None");
        result.put("endDate", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("startDate", "None");
        return result;
    }

    public static AdminGetBannedDevicesV4Builder builder() {
        return new AdminGetBannedDevicesV4Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public static class AdminGetBannedDevicesV4Builder {
        private String customBasePath;
        private String namespace;
        private String deviceType;
        private String endDate;
        private Integer limit;
        private Integer offset;
        private String startDate;

        AdminGetBannedDevicesV4Builder() {
        }

        public AdminGetBannedDevicesV4Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminGetBannedDevicesV4Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminGetBannedDevicesV4Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public AdminGetBannedDevicesV4Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public AdminGetBannedDevicesV4Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AdminGetBannedDevicesV4Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public AdminGetBannedDevicesV4Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public AdminGetBannedDevicesV4 build() {
            return new AdminGetBannedDevicesV4(this.customBasePath, this.namespace, this.deviceType, this.endDate, this.limit, this.offset, this.startDate);
        }

        public String toString() {
            return "AdminGetBannedDevicesV4.AdminGetBannedDevicesV4Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", deviceType=" + this.deviceType + ", endDate=" + this.endDate + ", limit=" + this.limit + ", offset=" + this.offset + ", startDate=" + this.startDate + ")";
        }
    }
}

