/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.country;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ModelCountryResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetCountryListV3
extends Operation {
    private String path = "/iam/v3/admin/namespaces/{namespace}/countries";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Boolean filterBlacklist;

    @Deprecated
    public AdminGetCountryListV3(String customBasePath, String namespace, Boolean filterBlacklist) {
        this.namespace = namespace;
        this.filterBlacklist = filterBlacklist;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("filterBlacklist", this.filterBlacklist == null ? null : Arrays.asList(String.valueOf(this.filterBlacklist)));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public List<ModelCountryResponse> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<ModelCountryResponse>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("filterBlacklist", "None");
        return result;
    }

    public static AdminGetCountryListV3Builder builder() {
        return new AdminGetCountryListV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getFilterBlacklist() {
        return this.filterBlacklist;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFilterBlacklist(Boolean filterBlacklist) {
        this.filterBlacklist = filterBlacklist;
    }

    public static class AdminGetCountryListV3Builder {
        private String customBasePath;
        private String namespace;
        private Boolean filterBlacklist;

        AdminGetCountryListV3Builder() {
        }

        public AdminGetCountryListV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminGetCountryListV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminGetCountryListV3Builder filterBlacklist(Boolean filterBlacklist) {
            this.filterBlacklist = filterBlacklist;
            return this;
        }

        public AdminGetCountryListV3 build() {
            return new AdminGetCountryListV3(this.customBasePath, this.namespace, this.filterBlacklist);
        }

        public String toString() {
            return "AdminGetCountryListV3.AdminGetCountryListV3Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", filterBlacklist=" + this.filterBlacklist + ")";
        }
    }
}

