/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.iam.operations.clients;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.iam.models.ClientmodelClientsV3Response;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetClientsByNamespaceV3
extends Operation {
    private String path = "/iam/v3/admin/namespaces/{namespace}/clients";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String clientId;
    private String clientName;
    private String clientType;
    private Integer limit;
    private Integer offset;
    private Boolean skipLoginQueue;

    @Deprecated
    public AdminGetClientsByNamespaceV3(String customBasePath, String namespace, String clientId, String clientName, String clientType, Integer limit, Integer offset, Boolean skipLoginQueue) {
        this.namespace = namespace;
        this.clientId = clientId;
        this.clientName = clientName;
        this.clientType = clientType;
        this.limit = limit;
        this.offset = offset;
        this.skipLoginQueue = skipLoginQueue;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("clientId", this.clientId == null ? null : Arrays.asList(this.clientId));
        queryParams.put("clientName", this.clientName == null ? null : Arrays.asList(this.clientName));
        queryParams.put("clientType", this.clientType == null ? null : Arrays.asList(this.clientType));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("skipLoginQueue", this.skipLoginQueue == null ? null : Arrays.asList(String.valueOf(this.skipLoginQueue)));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ClientmodelClientsV3Response parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ClientmodelClientsV3Response().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("clientId", "None");
        result.put("clientName", "None");
        result.put("clientType", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("skipLoginQueue", "None");
        return result;
    }

    public static AdminGetClientsByNamespaceV3Builder builder() {
        return new AdminGetClientsByNamespaceV3Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getClientType() {
        return this.clientType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Boolean getSkipLoginQueue() {
        return this.skipLoginQueue;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSkipLoginQueue(Boolean skipLoginQueue) {
        this.skipLoginQueue = skipLoginQueue;
    }

    public static class AdminGetClientsByNamespaceV3Builder {
        private String customBasePath;
        private String namespace;
        private String clientId;
        private String clientName;
        private String clientType;
        private Integer limit;
        private Integer offset;
        private Boolean skipLoginQueue;

        AdminGetClientsByNamespaceV3Builder() {
        }

        public AdminGetClientsByNamespaceV3Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminGetClientsByNamespaceV3Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminGetClientsByNamespaceV3Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public AdminGetClientsByNamespaceV3Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public AdminGetClientsByNamespaceV3Builder clientType(String clientType) {
            this.clientType = clientType;
            return this;
        }

        public AdminGetClientsByNamespaceV3Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AdminGetClientsByNamespaceV3Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public AdminGetClientsByNamespaceV3Builder skipLoginQueue(Boolean skipLoginQueue) {
            this.skipLoginQueue = skipLoginQueue;
            return this;
        }

        public AdminGetClientsByNamespaceV3 build() {
            return new AdminGetClientsByNamespaceV3(this.customBasePath, this.namespace, this.clientId, this.clientName, this.clientType, this.limit, this.offset, this.skipLoginQueue);
        }

        public String toString() {
            return "AdminGetClientsByNamespaceV3.AdminGetClientsByNamespaceV3Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", clientId=" + this.clientId + ", clientName=" + this.clientName + ", clientType=" + this.clientType + ", limit=" + this.limit + ", offset=" + this.offset + ", skipLoginQueue=" + this.skipLoginQueue + ")";
        }
    }
}

